<?php
session_start();
require_once 'config.php';
require_once 'rut.php';

function e($text) { return htmlspecialchars($text ?? '', ENT_QUOTES, 'UTF-8'); }
function user() { return $_SESSION['user'] ?? null; }

$user = user();
$msg = $error = null;

// Redirección si no hay sesión o si ya no tiene el flag de activador
if (!$user) {
    header('Location: index.php');
    exit;
}

// Si el usuario ya cambió su contraseña (activador está vacío) lo mandamos al dashboard.
if (empty($user['activador'])) {
    header('Location: index.php?p=dashboard');
    exit;
}

$config = include 'config.php';
$dsn = "mysql:host={$config['db']['host']};dbname={$config['db']['dbname']};charset=utf8mb4";
$pdo = new PDO($dsn, $config['db']['user'], $config['db']['pass'], [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
]);

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $password = $_POST['password'] ?? '';
    $password_confirm = $_POST['password_confirm'] ?? '';

    if (strlen($password) < 8) {
        $error = "❌ La contraseña debe tener al menos 8 caracteres.";
    } elseif ($password !== $password_confirm) {
        $error = "❌ Las contraseñas no coinciden.";
    } else {
        $new_hash = password_hash($password, PASSWORD_DEFAULT);
        
        // 1. Actualizar contraseña y eliminar el flag 'activador'
        $stmt = $pdo->prepare("UPDATE socios SET password_hash = ?, activador = NULL WHERE id = ?");
        $stmt->execute([$new_hash, $user['id']]);

        // 2. Actualizar la sesión
        $user['password_hash'] = $new_hash;
        $user['activador'] = NULL;
        $_SESSION['user'] = $user;

        $msg = "✅ Contraseña actualizada con éxito. Redirigiendo...";
        header('Refresh: 3; URL=index.php?p=dashboard'); // Redirige después de 3 segundos
        exit;
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>🔒 Primer Acceso - Cambiar Contraseña</title>
    <meta charset="utf-8">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        :root { --primary: #77216F; --secondary: #5E2750; }
        *{margin:0;padding:0;box-sizing:border-box;}
        body{font-family:'Segoe UI',Arial,sans-serif;background:linear-gradient(135deg, var(--primary), var(--secondary));min-height:100vh;display:flex;align-items:center;justify-content:center;}
        .container{max-width:500px;width:90%;padding:30px;background:white;border-radius:15px;box-shadow:0 15px 40px rgba(0,0,0,0.2);text-align:center;}
        .header{margin-bottom:20px;color:var(--primary);}
        .form-group{margin-bottom:15px;text-align:left;}
        .form-group label{display:block;margin-bottom:5px;font-weight:600;color:#555;}
        .form-group input{width:100%;padding:12px;border:1px solid #ddd;border-radius:8px;font-size:16px;}
        .btn-update{width:100%;padding:15px;background:var(--primary);color:white;border:none;border-radius:8px;font-size:1.1em;cursor:pointer;transition:background 0.3s;}
        .btn-update:hover{background:var(--secondary);}
        .msg-success{background:#d4edda;color:#155724;padding:12px;border-radius:8px;margin-bottom:20px;}
        .msg-error{background:#f8d7da;color:#721c24;padding:12px;border-radius:8px;margin-bottom:20px;}
    </style>
</head>
<body>
<div class="container">
    <div class="header">
        <h1><i class="fas fa-key"></i> Establecer Contraseña</h1>
        <p>Estás usando tu contraseña temporal. Por favor, crea una nueva.</p>
    </div>

    <?php if($msg): ?>
    <div class="msg-success"><?= $msg ?></div>
    <?php elseif($error): ?>
    <div class="msg-error"><?= $error ?></div>
    <?php endif; ?>

    <form method="POST">
        <div class="form-group">
            <label for="password"><i class="fas fa-lock"></i> Nueva Contraseña (mín. 8 caracteres)</label>
            <input type="password" id="password" name="password" required>
        </div>
        <div class="form-group">
            <label for="password_confirm"><i class="fas fa-lock"></i> Repetir Contraseña</label>
            <input type="password" id="password_confirm" name="password_confirm" required>
        </div>
        <button type="submit" class="btn-update">
            <i class="fas fa-save"></i> Guardar y Acceder
        </button>
    </form>
</div>
</body>
</html>