<?php
session_start();

// ✅ USAR config.php QUE FUNCIONA
$config = include 'config.php';
$dsn = "mysql:host={$config['db']['host']};dbname={$config['db']['dbname']};charset=utf8mb4";
$pdo = new PDO($dsn, $config['db']['user'], $config['db']['pass'], [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
]);

function e($text) { return htmlspecialchars($text ?? '', ENT_QUOTES, 'UTF-8'); }

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $rut = trim($_POST['rut']);
    $password = $_POST['password'];
    
    // Al loguear, obtener el nombre del SSR con un JOIN
    $stmt = $pdo->prepare("SELECT s.*, r.nombre as ssr_nombre FROM socios s LEFT JOIN ssr r ON s.ssr_id = r.id WHERE (s.rut = ? OR s.email = ?) AND s.activo = 1");
    $stmt->execute([$rut, $rut]);
    $user = $stmt->fetch();
    
    if ($user && password_verify($password, $user['password_hash'])) {
        $_SESSION['user'] = $user;
        header('Location: /index.php?p=dashboard');
        exit;
    } else {
        $error = "❌ RUT/Email o contraseña incorrectos";
    }
}

$p = $_GET['p'] ?? '';
if ($p === 'dashboard') {
    $user = $_SESSION['user'] ?? null;
    if (!$user) {
        header('Location: /index.php');
        exit;
    }
    ?>
    <!DOCTYPE html>
    <html>
    <head>
        <title>🚀 Dashboard SSR Completo</title>
        <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
        <style>
            body{font-family:'Segoe UI',Arial,sans-serif;background:linear-gradient(135deg,#667eea 0%,#764ba2 100%);min-height:100vh;padding:20px;}
            .header{background:linear-gradient(135deg,#77216F,#5E2750);color:white;padding:40px;border-radius:20px;text-align:center;box-shadow:0 15px 35px rgba(119,33,111,0.3);}
            .stats{display:grid;grid-template-columns:repeat(auto-fit,minmax(250px,1fr));gap:20px;margin:30px 0;}
            .stat{background:white;padding:30px;border-radius:15px;text-align:center;box-shadow:0 10px 30px rgba(0,0,0,0.1);}
            .stat h3{color:#666;margin:0 0 15px 0;}
            .stat h2{color:#77216F;font-size:2.5em;margin:0;}
            .menu{background:white;padding:30px;border-radius:15px;margin:20px 0;box-shadow:0 10px 30px rgba(0,0,0,0.1);}
            .menu h3{margin-bottom:20px;color:#333;}
            .btn{display:inline-block;padding:15px 30px;background:#28a745;color:white;text-decoration:none;border-radius:10px;margin:10px;font-weight:600;font-size:16px;transition:all 0.3s;}
            .btn:hover{transform:translateY(-3px);box-shadow:0 10px 25px rgba(40,167,69,0.4);}
            .btn-danger{background:#dc3545;}
            .btn-danger:hover{box-shadow:0 10px 25px rgba(220,53,69,0.4);}
            .btn-warning{background:#ffc107;color:#212529;}
            .btn-warning:hover{box-shadow:0 10px 25px rgba(255,193,7,0.4);}
            .btn-info{background:#17a2b8;}
            .btn-info:hover{box-shadow:0 10px 25px rgba(23,162,184,0.4);}
            @media(max-width:768px){.stats{grid-template-columns:1fr;}}
            
            /* ESTILOS PARA EL NUEVO MENÚ DE ADMINISTRACIÓN */
            .admin-link {
                background: var(--bg-color, #333);
                color: white;
                padding: 20px;
                border-radius: 12px;
                text-decoration: none;
                transition: transform 0.2s, box-shadow 0.2s;
                box-shadow: 0 4px 15px rgba(0,0,0,0.1);
            }

            .admin-link:hover {
                transform: translateY(-5px);
                box-shadow: 0 8px 25px rgba(0,0,0,0.2);
            }

            .admin-link h3 {
                margin-bottom: 10px;
                font-size: 1.25rem;
            }

            .admin-link p {
                font-size: 0.9rem;
                opacity: 0.9;
            }
        </style>
    </head>
    <body>
        <div class="header">
            <h1><i class="fas fa-tachometer-alt"></i> Dashboard SSR Completo</h1>
            <p><strong><?= e($user['nombre_completo']) ?></strong> | <?= e($user['ssr_nombre'] ?? 'GLOBAL') ?></p>
            <p><?= $user['rol']==1?'🛡️ SuperAdmin':($user['rol']==2?'👑 Admin':'👤 Socio') ?></p>
        </div>

        <div class="stats">
            <div class="stat">
                <h3>👥 Socios Total (Mi SSR)</h3>
                <h2><?= $pdo->query("SELECT COUNT(*) FROM socios WHERE ssr_id = {$user['ssr_id']}")->fetchColumn() ?></h2>
            </div>
            <div class="stat">
                <h3>📊 Rendiciones (Mi SSR)</h3>
                <h2><?= $pdo->query("SELECT COUNT(*) FROM rendiciones WHERE ssr_id = {$user['ssr_id']}")->fetchColumn() ?></h2>
            </div>
            <div class="stat">
                <h3>🏢 SSR ID</h3>
                <h2><?= $user['ssr_id'] ?></h2>
            </div>
            <?php if($user['rol'] == 1): ?>
            <div class="stat">
                <h3>🌐 Total SSR</h3>
                <h2><?= $pdo->query("SELECT COUNT(*) FROM ssr")->fetchColumn() ?></h2>
            </div>
            <?php endif; ?>
        </div>

        <?php if ($user['rol'] <= 2): // Solo visible para Superadmin (1) y Admin SSR (2) ?>
        <div class="card-admin" style="margin-top: 40px;">
            <h2 style="color: #77216F; margin-bottom: 20px;"><i class="fas fa-tools"></i> Herramientas de Administración</h2>
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px;">

                <a href="admin_socios.php" class="admin-link" style="--bg-color: #0d6efd;">
                    <h3><i class="fas fa-users"></i> Gestión de Socios</h3>
                    <p>Crear, editar y desactivar usuarios.</p>
                </a>

                <?php if ($user['rol'] == 1): // Solo visible para Superadmin (1) ?>
                <a href="admin_ssr.php" class="admin-link" style="--bg-color: #77216F;">
                    <h3><i class="fas fa-building"></i> Gestión de SSR (Empresas)</h3>
                    <p>Crear y administrar las entidades.</p>
                </a>
                <?php endif; ?>

                <a href="socios_importar.php" class="admin-link" style="--bg-color: #198754;">
                    <h3><i class="fas fa-file-csv"></i> Importar Socios</h3>
                    <p>Carga masiva de usuarios vía CSV.</p>
                </a>
                
                <a href="ver_activadores.php" class="admin-link" style="--bg-color: #ffc107; color: #333;">
                    <h3><i class="fas fa-bolt"></i> Códigos Activadores</h3>
                    <p>Ver y generar códigos de activación.</p>
                </a>

            </div>
        </div>
        <?php endif; ?>
        <div class="menu">
            <h3>🔧 ADMINISTRACIÓN PRINCIPAL:</h3>
            <?php if($user['rol'] <= 2): ?>
            <a href="admin_socios.php" class="btn">👥 Gestión Socios</a>
            <a href="socios_importar.php" class="btn btn-warning">📁 Carga Masiva CSV</a>
            <?php endif; ?>
            
            <a href="/rendiciones_públicas.php?ssr=<?= $user['ssr_id'] ?>" target="_blank" class="btn btn-info">👁️ Vista Pública</a>
            
            <?php if($user['rol'] <= 2): ?>
            <a href="rendiciones_admin.php" class="btn">📋 Gestionar Rendiciones</a>
            <?php endif; ?>

            <h3 style="margin-top:30px;">🔑 SISTEMA DE ACTIVACIÓN:</h3>
            <a href="/activacion.php" class="btn btn-warning">⚡ Panel Activación RUT+Cliente</a>
            <a href="/ver_activadores.php" class="btn">🔍 Ver Códigos Activador</a>

            <a href="index.php?logout=1" class="btn btn-danger">🚪 Salir</a>
        </div>
    </body>
    </html>
    <?php
    exit;
}

if (isset($_GET['logout'])) {
    session_destroy();
    header('Location: index.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>🚀 Rendiciones SSR</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        *{margin:0;padding:0;box-sizing:border-box;}
        body{font-family:'Segoe UI',Tahoma,Arial,sans-serif;background:linear-gradient(135deg,#667eea 0%,#764ba2 100%);min-height:100vh;display:flex;align-items:center;justify-content:center;padding:20px;}
        .login-container{max-width:420px;width:100%;background:#fff;border-radius:20px;box-shadow:0 25px 80px rgba(0,0,0,0.25);overflow:hidden;}
        .header{background:linear-gradient(135deg,#77216F,#5E2750);color:#fff;padding:40px 30px;text-align:center;}
        .header h1{font-size:2.2em;margin-bottom:10px;}
        .login-form{padding:40px;}
        .form-group{margin-bottom:25px;}
        label{display:block;margin-bottom:8px;color:#333;font-weight:500;}
        input{padding:15px;border:2px solid #eee;border-radius:12px;width:100%;font-size:16px;transition:all 0.3s;font-family:inherit;}
        input:focus{outline:none;border-color:#77216F;box-shadow:0 0 0 3px rgba(119,33,111,0.1);}
        .btn-login{width:100%;padding:16px;background:linear-gradient(135deg,#77216F,#5E2750);color:#fff;border:none;border-radius:12px;font-size:18px;font-weight:600;cursor:pointer;transition:all 0.3s;}
        .btn-login:hover{transform:translateY(-2px);box-shadow:0 10px 30px rgba(119,33,111,0.4);}
        .error{background:#f8d7da;color:#721c24;padding:15px;border-radius:10px;margin:20px 0;border-left:4px solid #dc3545;}
        .credentials{background:#f8f9fa;padding:20px;border-radius:12px;margin:20px 0;border-left:4px solid #28a745;}
        .credential{padding:12px;margin:8px 0;background:#fff;border-radius:8px;border-left:4px solid #17a2b8;font-family:monospace;}
    </style>
</head>
<body>
<div class="login-container">
    <div class="header">
        <h1><i class="fas fa-file-invoice-dollar"></i> Rendiciones SSR</h1>
        <p>Plataforma Oficial de Rendición de Cuentas</p>
    </div>

    <div class="login-form">
        <?php if(isset($error)): ?>
        <div class="error"><?= $error ?></div>
        <?php endif; ?>

        <form method="POST">
            <div class="form-group">
                <label><i class="fas fa-id-card"></i> RUT:</label>
                <input type="text" name="rut" required placeholder="1-9" value="<?= e($_POST['rut'] ?? '') ?>" autofocus>
            </div>
            <div class="form-group">
                <label><i class="fas fa-lock"></i> Contraseña:</label>
                <input type="password" name="password" required placeholder="password">
            </div>
            <button type="submit" class="btn-login">
                <i class="fas fa-sign-in-alt"></i> Acceder
            </button>
        </form>

        <div class="credentials">
            <strong>✅ Credenciales Demo:</strong>
            <div class="credential"><strong>SUPERADMIN:</strong> <code>1-9</code> / <code>password</code></div>
            <div class="credential"><strong>ADMIN:</strong> <code>12.345.678-9</code> / <code>password</code></div>
        </div>
    </div>
</div>
</body>
</html>