<?php
session_start();
$config = include 'config.php';
$dsn = "mysql:host={$config['db']['host']};dbname={$config['db']['dbname']};charset=utf8mb4";
$pdo = new PDO($dsn, $config['db']['user'], $config['db']['pass'], [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
]);

$user = $_SESSION['user'] ?? null;
if (!$user || $user['rol'] > 2) { header('Location: index.php'); exit; }

$msg = '';
if (!empty($_FILES['archivo']['tmp_name'])) {
    $handle = fopen($_FILES['archivo']['tmp_name'], 'r');
    $n = 0; $success = 0; $errors = [];
    while (($row = fgetcsv($handle, 1000, ",")) !== FALSE) {
        $n++; if ($n==1) continue;
        
        $rut = trim($row[0]); 
        $nombre_completo = trim($row[1]);
        $email = trim($row[2]); 
        $rol = (int)($row[3] ?? 5); 
        $ssr_id = (int)($row[4] ?? 1);
        
        // ✅ ACTIVADOR RUT + BOLETAS
        $boleta1 = trim($row[5] ?? ''); $boleta2 = trim($row[6] ?? ''); $boleta3 = trim($row[7] ?? '');
        $activador = "$rut+$boleta1+$boleta2+$boleta3";
        
        if (!$rut || !$nombre_completo) { $errors[]="Fila $n sin RUT/nombre"; continue; }
        $check = $pdo->prepare("SELECT id FROM socios WHERE rut=?"); $check->execute([$rut]);
        if ($check->fetch()) { $errors[]="Fila $n rut ya existe"; continue; }
        
        $hash = password_hash('password', PASSWORD_DEFAULT);
        $pdo->prepare("INSERT INTO socios (rut, nombre_completo, email, rol, ssr_id, password_hash, activo, activador) VALUES (?, ?, ?, ?, ?, ?, 1, ?)")
            ->execute([$rut, $nombre_completo, $email, $rol, $ssr_id, $hash, $activador]); 
        $success++;
    }
    fclose($handle); 
    $msg = "✅ Cargados: $success | Errores: " . count($errors);
}
?>
<!DOCTYPE html>
<html>
<head><title>Importar Socios + Activador</title>
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
<style>*{margin:0;padding:0;box-sizing:border-box;}body{font-family:'Segoe UI',Arial,sans-serif;background:linear-gradient(135deg,#667eea 0%,#764ba2 100%);min-height:100vh;padding:30px;}.container{max-width:800px;margin:0 auto;}.header{background:linear-gradient(135deg,#77216F,#5E2750);color:white;padding:40px;border-radius:20px;text-align:center;box-shadow:0 15px 35px rgba(119,33,111,0.3);}.form-container{background:white;padding:40px;border-radius:20px;margin:30px 0;box-shadow:0 15px 40px rgba(0,0,0,0.1);}.help{background:#fff3cd;padding:25px;border-radius:15px;margin-bottom:30px;border-left:5px solid #ffc107;}.btn-import{width:100%;padding:18px;background:linear-gradient(135deg,#28a745,#218838);color:white;border:none;border-radius:12px;font-size:18px;font-weight:600;cursor:pointer;margin-top:20px;}</style>
</head>
<body>
<div class="container">
    <div class="header">
        <h1><i class="fas fa-file-csv"></i> Carga Masiva + Activador</h1>
    </div>
    <div class="form-container">
        <?php if($msg): ?><div style="background:#d4edda;color:#155724;padding:20px;border-radius:12px;"><?= $msg ?></div><?php endif; ?>
        
        <div class="help">
            <h4><i class="fas fa-info-circle"></i> Formato CSV (8 columnas):</h4>
            <div style="background:#f8f9fa;padding:15px;border-radius:10px;font-family:monospace;font-size:14px;">
                rut,nombre,email,rol,ssr_id,boleta1,boleta2,boleta3<br>
                12.345.678-9,Juan Pérez,juan@cl,5,1,12345,67890,11111<br>
                98.765.432-1,María Gómez,maria@cl,5,1,22222,33333,44444
            </div>
            <strong>Activador:</strong> rut+boleta1+boleta2+boleta3 → <code>12.345.678-9+12345+67890+11111</code>
        </div>

        <form method="POST" enctype="multipart/form-data">
            <input type="file" name="archivo" accept=".csv" required style="width:100%;padding:15px;border:2px dashed #dee2e6;border-radius:12px;margin-bottom:20px;">
            <button type="submit" class="btn-import">🚀 Importar con Activador</button>
        </form>
        <a href="admin_socios.php" style="display:inline-block;background:#6c757d;color:white;padding:12px 25px;border-radius:10px;text-decoration:none;margin-top:20px;">← Gestión Socios</a>
    </div>
</div>
</body>
</html>
