<?php
namespace Core\Controllers;

use Core\Classes\Auth;
use Core\Classes\Backup;

class BackupController {
    private $auth;
    private $backup;

    public function __construct() {
        $this->auth = new Auth();
        $this->backup = new Backup('localhost', 'dbuser', 'dbpass', 'dbname'); // Rellenar con datos reales
    }

    public function crear() {
        $this->checkAuth();
        $ruta = __DIR__ . '/../../backups/backup_' . date('Ymd_His') . '.sql';
        if ($this->backup->crearBackup($ruta)) {
            $mensaje = "Backup creado exitosamente: $ruta";
        } else {
            $mensaje = "Error al crear backup";
        }
        require __DIR__ . '/../../views/backup/crear.php';
    }

    public function restaurar() {
        $this->checkAuth();
        if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['backup_file'])) {
            $fileTmpPath = $_FILES['backup_file']['tmp_name'];
            if ($this->backup->restaurarBackup($fileTmpPath)) {
                $mensaje = "Backup restaurado correctamente";
            } else {
                $mensaje = "Error al restaurar backup";
            }
        }
        require __DIR__ . '/../../views/backup/restaurar.php';
    }

    private function checkAuth() {
        if (!$this->auth->check()) {
            header('Location: /login');
            exit;
        }
    }
}
