<?php
namespace Core\Controllers;

use Core\Classes\Auth;
use Core\Models\Categoria;

class CategoriaController {
    private $auth;
    private $model;

    public function __construct() {
        $this->auth = new Auth();
        $this->model = new Categoria();
    }

    public function index() {
        $this->checkAuth();
        $empresa_id = $_SESSION['empresa_id'];
        $categorias = $this->model->getAllByEmpresa($empresa_id);
        require __DIR__ . '/../../views/categoria/index.php';
    }

    public function create() {
        $this->checkAuth();
        require __DIR__ . '/../../views/categoria/create.php';
    }

    public function store() {
        $this->checkAuth();
        $data = [
            'empresa_id' => $_SESSION['empresa_id'],
            'nombre' => $_POST['nombre'],
            'descripcion' => $_POST['descripcion'] ?? '',
            'estado' => $_POST['estado'] ?? 'activo'
        ];
        if ($this->model->create($data)) {
            header('Location: /categoria');
            exit;
        }
        $error = 'Error al crear categoría';
        require __DIR__ . '/../../views/categoria/create.php';
    }

    public function edit($id) {
        $this->checkAuth();
        $categoria = $this->model->getById($id);
        if (!$categoria) {
            header('Location: /categoria');
            exit;
        }
        require __DIR__ . '/../../views/categoria/edit.php';
    }

    public function update($id) {
        $this->checkAuth();
        $data = [
            'nombre' => $_POST['nombre'],
            'descripcion' => $_POST['descripcion'] ?? '',
            'estado' => $_POST['estado'] ?? 'activo'
        ];
        if ($this->model->update($id, $data)) {
            header('Location: /categoria');
            exit;
        }
        $error = 'Error al actualizar categoría';
        $categoria = $this->model->getById($id);
        require __DIR__ . '/../../views/categoria/edit.php';
    }

    public function delete($id) {
        $this->checkAuth();
        $this->model->delete($id);
        header('Location: /categoria');
        exit;
    }

    private function checkAuth() {
        if (!$this->auth->check()) {
            header('Location: /login');
            exit;
        }
    }
}
