<?php
namespace Core\Controllers;

use Core\Classes\Auth;
use Core\Models\Log;

class LogController {
    private $auth;
    private $model;

    public function __construct() {
        $this->auth = new Auth();
        $this->model = new Log();
    }

    public function index() {
        $this->checkAuth();
        $logs = $this->model->obtenerTodos();
        require __DIR__ . '/../../views/log/index.php';
    }

    private function checkAuth() {
        if (!$this->auth->check()) {
            header('Location: /login');
            exit;
        }
    }
}
