<?php
namespace Core\Controllers;

use Core\Classes\Auth;
use Core\Models\Tesoreria;

class TesoreriaController {
    private $auth;
    private $model;

    public function __construct() {
        $this->auth = new Auth();
        $this->model = new Tesoreria();
    }

    public function index() {
        $this->checkAuth();
        $empresa_id = $_SESSION['empresa_id'];
        $movimientos = $this->model->getAllByEmpresa($empresa_id);
        require __DIR__ . '/../../views/tesoreria/index.php';
    }

    public function create() {
        $this->checkAuth();
        require __DIR__ . '/../../views/tesoreria/create.php';
    }

    public function store() {
        $this->checkAuth();
        $data = [
            'empresa_id' => $_SESSION['empresa_id'],
            'tipo' => $_POST['tipo'],
            'monto' => $_POST['monto'],
            'cuenta' => $_POST['cuenta'],
            'descripcion' => $_POST['descripcion'],
            'fecha_movimiento' => $_POST['fecha_movimiento'],
            'creado_por' => $_SESSION['user_id']
        ];
        if ($this->model->create($data)) {
            header('Location: /tesoreria');
            exit;
        }
        $error = 'Error al crear movimiento';
        require __DIR__ . '/../../views/tesoreria/create.php';
    }

    public function edit($id) {
        $this->checkAuth();
        $movimiento = $this->model->getById($id);
        if (!$movimiento) {
            header('Location: /tesoreria');
            exit;
        }
        require __DIR__ . '/../../views/tesoreria/edit.php';
    }

    public function update($id) {
        $this->checkAuth();
        $data = [
            'tipo' => $_POST['tipo'],
            'monto' => $_POST['monto'],
            'cuenta' => $_POST['cuenta'],
            'descripcion' => $_POST['descripcion'],
            'fecha_movimiento' => $_POST['fecha_movimiento'],
            'actualizado_por' => $_SESSION['user_id']
        ];
        if ($this->model->update($id, $data)) {
            header('Location: /tesoreria');
            exit;
        }
        $error = 'Error al actualizar movimiento';
        $movimiento = $this->model->getById($id);
        require __DIR__ . '/../../views/tesoreria/edit.php';
    }

    public function delete($id) {
        $this->checkAuth();
        $this->model->delete($id);
        header('Location: /tesoreria');
        exit;
    }

    private function checkAuth() {
        if (!$this->auth->check()) {
            header('Location: /login');
            exit;
        }
    }
}
