<?php
namespace Core\Models;

use Core\Classes\Database;

class Caso {
    private $db;

    public function __construct() {
        $this->db = Database::getInstance()->getConnection();
    }

    public function getAllByEmpresa($empresa_id) {
        $stmt = $this->db->prepare('SELECT * FROM casos WHERE empresa_id = ? ORDER BY fecha_creacion DESC');
        $stmt->execute([$empresa_id]);
        return $stmt->fetchAll();
    }

    public function getById($id) {
        $stmt = $this->db->prepare('SELECT * FROM casos WHERE id = ?');
        $stmt->execute([$id]);
        return $stmt->fetch();
    }

    public function create($data) {
        $stmt = $this->db->prepare('INSERT INTO casos (empresa_id, cliente_id, tipo, estado, asunto, descripcion, fecha_creacion, creado_por) VALUES (?, ?, ?, ?, ?, ?, NOW(), ?)');
        return $stmt->execute([
            $data['empresa_id'],
            $data['cliente_id'],
            $data['tipo'],
            $data['estado'] ?? 'pendiente',
            $data['asunto'],
            $data['descripcion'],
            $data['creado_por']
        ]);
    }

    public function update($id, $data) {
        $stmt = $this->db->prepare('UPDATE casos SET tipo = ?, estado = ?, asunto = ?, descripcion = ?, asignado_a = ?, fecha_actualizacion = NOW() WHERE id = ?');
        return $stmt->execute([
            $data['tipo'],
            $data['estado'],
            $data['asunto'],
            $data['descripcion'],
            $data['asignado_a'] ?? null,
            $id
        ]);
    }

    public function delete($id) {
        $stmt = $this->db->prepare('DELETE FROM casos WHERE id = ?');
        return $stmt->execute([$id]);
    }
}
