<?php
namespace Core\Models;

use Core\Classes\Database;

class Log {
    private $db;

    public function __construct() {
        $this->db = Database::getInstance()->getConnection();
    }

    public function registrar($usuario_id, $accion, $detalle) {
        $stmt = $this->db->prepare('INSERT INTO logs (usuario_id, accion, detalle, fecha) VALUES (?, ?, ?, NOW())');
        return $stmt->execute([$usuario_id, $accion, $detalle]);
    }

    public function obtenerTodos() {
        $stmt = $this->db->query('SELECT l.*, u.nombres, u.apellidos FROM logs l LEFT JOIN core_usuarios u ON l.usuario_id = u.id ORDER BY fecha DESC');
        return $stmt->fetchAll();
    }
}
