<?php
namespace Core\Models;

use Core\Classes\Database;

class Respuesta {
    private $db;

    public function __construct() {
        $this->db = Database::getInstance()->getConnection();
    }

    public function getAllByCaso($caso_id) {
        $stmt = $this->db->prepare('SELECT * FROM respuestas WHERE caso_id = ? ORDER BY fecha_creacion ASC');
        $stmt->execute([$caso_id]);
        return $stmt->fetchAll();
    }

    public function create($data) {
        $stmt = $this->db->prepare('INSERT INTO respuestas (caso_id, usuario_id, texto, fecha_creacion) VALUES (?, ?, ?, NOW())');
        return $stmt->execute([
            $data['caso_id'],
            $data['usuario_id'],
            $data['texto']
        ]);
    }
}
