<?php
namespace Core\Models;

use Core\Classes\Database;

class Seguimiento {
    private $db;

    public function __construct() {
        $this->db = Database::getInstance()->getConnection();
    }

    public function getAllByEmpresa($empresa_id) {
        $stmt = $this->db->prepare('SELECT * FROM seguimiento WHERE empresa_id = ? AND deleted_at IS NULL ORDER BY fecha_seguimiento DESC');
        $stmt->execute([$empresa_id]);
        return $stmt->fetchAll();
    }

    public function getById($id) {
        $stmt = $this->db->prepare('SELECT * FROM seguimiento WHERE id = ? AND deleted_at IS NULL');
        $stmt->execute([$id]);
        return $stmt->fetch();
    }

    public function create($data) {
        $stmt = $this->db->prepare('INSERT INTO seguimiento (empresa_id, entidad, entidad_id, descripcion, estado, fecha_seguimiento, creado_por) VALUES (?, ?, ?, ?, ?, ?, ?)');
        return $stmt->execute([
            $data['empresa_id'],
            $data['entidad'],
            $data['entidad_id'],
            $data['descripcion'],
            $data['estado'] ?? 'pendiente',
            $data['fecha_seguimiento'],
            $data['creado_por']
        ]);
    }

    public function update($id, $data) {
        $stmt = $this->db->prepare('UPDATE seguimiento SET descripcion = ?, estado = ?, fecha_seguimiento = ?, actualizado_por = ?, fecha_actualizacion = NOW() WHERE id = ?');
        return $stmt->execute([
            $data['descripcion'],
            $data['estado'],
            $data['fecha_seguimiento'],
            $data['actualizado_por'],
            $id
        ]);
    }

    public function delete($id) {
        $stmt = $this->db->prepare('UPDATE seguimiento SET deleted_at = NOW() WHERE id = ?');
        return $stmt->execute([$id]);
    }
}
