<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Clientes</title>
    <link rel="stylesheet" href="/public/css/style.css" />
</head>
<body>
    <h1>Clientes</h1>
    <a href="/cliente/create">Nuevo Cliente</a>
    <table border="1" cellpadding="5" cellspacing="0">
        <thead>
            <tr>
                <th>ID</th>
                <th>RUT</th>
                <th>Nombres</th>
                <th>Apellidos</th>
                <th>Correo</th>
                <th>Teléfono</th>
                <th>Estado</th>
                <th>Acciones</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($clientes as $cliente): ?>
            <tr>
                <td><?= htmlspecialchars($cliente['id']) ?></td>
                <td><?= htmlspecialchars($cliente['rut']) ?></td>
                <td><?= htmlspecialchars($cliente['nombres']) ?></td>
                <td><?= htmlspecialchars($cliente['apellidos']) ?></td>
                <td><?= htmlspecialchars($cliente['correo']) ?></td>
                <td><?= htmlspecialchars($cliente['telefono']) ?></td>
                <td><?= htmlspecialchars($cliente['estado']) ?></td>
                <td>
                    <a href="/cliente/edit/<?= $cliente['id'] ?>">Editar</a> |
                    <a href="/cliente/delete/<?= $cliente['id'] ?>" onclick="return confirm('¿Confirmar eliminación?')">Eliminar</a>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</body>
</html>
