<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Editar Caso Contactabilidad</title>
    <link rel="stylesheet" href="/public/css/style.css" />
</head>
<body>
    <h1>Editar Caso #<?= htmlspecialchars($caso['id']) ?></h1>

    <?php if (isset($error)): ?>
        <p class="error"><?= htmlspecialchars($error) ?></p>
    <?php endif; ?>

    <form method="POST" action="/contactabilidad/update/<?= $caso['id'] ?>">
        <label for="tipo">Tipo</label>
        <select id="tipo" name="tipo" required>
            <option value="reclamo" <?= $caso['tipo'] === 'reclamo' ? 'selected' : '' ?>>Reclamo</option>
            <option value="consulta" <?= $caso['tipo'] === 'consulta' ? 'selected' : '' ?>>Consulta</option>
            <option value="sugerencia" <?= $caso['tipo'] === 'sugerencia' ? 'selected' : '' ?>>Sugerencia</option>
            <option value="felicitacion" <?= $caso['tipo'] === 'felicitacion' ? 'selected' : '' ?>>Felicitación</option>
            <option value="contacto" <?= $caso['tipo'] === 'contacto' ? 'selected' : '' ?>>Contacto</option>
        </select>

        <label for="estado">Estado</label>
        <select id="estado" name="estado" required>
            <option value="recibido" <?= $caso['estado'] === 'recibido' ? 'selected' : '' ?>>Recibido</option>
            <option value="gestion" <?= $caso['estado'] === 'gestion' ? 'selected' : '' ?>>En Gestión</option>
            <option value="aprobacion" <?= $caso['estado'] === 'aprobacion' ? 'selected' : '' ?>>En Aprobación</option>
            <option value="respondido" <?= $caso['estado'] === 'respondido' ? 'selected' : '' ?>>Respondido</option>
            <option value="cerrado" <?= $caso['estado'] === 'cerrado' ? 'selected' : '' ?>>Cerrado</option>
        </select>

        <label for="asunto">Asunto</label>
        <input type="text" id="asunto" name="asunto" value="<?= htmlspecialchars($caso['asunto']) ?>" required />

        <label for="descripcion">Descripción</label>
        <textarea id="descripcion" name="descripcion" rows="5" required><?= htmlspecialchars($caso['descripcion']) ?></textarea>

        <label for="fecha_cierre">Fecha de Cierre</label>
        <input type="date" id="fecha_cierre" name="fecha_cierre" value="<?= htmlspecialchars(substr($caso['fecha_cierre'] ?? '', 0, 10)) ?>" />

        <label for="asignado_a">Asignado a</label>
        <input type="number" id="asignado_a" name="asignado_a" value="<?= htmlspecialchars($caso['asignado_a'] ?? '') ?>" />

        <button type="submit">Actualizar Caso</button>
    </form>

    <a href="/contactabilidad">Volver al listado</a>
</body>
</html>
