<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title><?= isset($empresa) ? 'Editar Empresa' : 'Crear Nueva Empresa' ?></title>
    <link rel="stylesheet" href="/public/css/style.css" />
</head>
<body>
    <h1><?= isset($empresa) ? 'Editar Empresa' : 'Crear Nueva Empresa' ?></h1>

    <form method="POST" action="<?= isset($empresa) ? '/empresa/update/' . $empresa['id'] : '/empresa/store' ?>">
        <label for="rut">RUT</label>
        <input type="text" id="rut" name="rut" value="<?= htmlspecialchars($empresa['rut'] ?? '') ?>" required />

        <label for="razon_social">Razón Social</label>
        <input type="text" id="razon_social" name="razon_social" value="<?= htmlspecialchars($empresa['razon_social'] ?? '') ?>" required />

        <label for="nombre_comercial">Nombre Comercial</label>
        <input type="text" id="nombre_comercial" name="nombre_comercial" value="<?= htmlspecialchars($empresa['nombre_comercial'] ?? '') ?>" />

        <label for="direccion">Dirección</label>
        <input type="text" id="direccion" name="direccion" value="<?= htmlspecialchars($empresa['direccion'] ?? '') ?>" />

        <label for="comuna">Comuna</label>
        <input type="text" id="comuna" name="comuna" value="<?= htmlspecialchars($empresa['comuna'] ?? '') ?>" />

        <label for="region">Región</label>
        <input type="text" id="region" name="region" value="<?= htmlspecialchars($empresa['region'] ?? '') ?>" />

        <label for="telefono">Teléfono</label>
        <input type="text" id="telefono" name="telefono" value="<?= htmlspecialchars($empresa['telefono'] ?? '') ?>" />

        <label for="email">Email</label>
        <input type="email" id="email" name="email" value="<?= htmlspecialchars($empresa['email'] ?? '') ?>" />

        <label for="web">Sitio Web</label>
        <input type="url" id="web" name="web" value="<?= htmlspecialchars($empresa['web'] ?? '') ?>" />

        <label for="estado">Estado</label>
        <select id="estado" name="estado">
            <option value="activo" <?= (isset($empresa['estado']) && $empresa['estado'] === 'activo') ? 'selected' : '' ?>>Activo</option>
            <option value="suspendido" <?= (isset($empresa['estado']) && $empresa['estado'] === 'suspendido') ? 'selected' : '' ?>>Suspendido</option>
            <option value="inactivo" <?= (isset($empresa['estado']) && $empresa['estado'] === 'inactivo') ? 'selected' : '' ?>>Inactivo</option>
        </select>

        <label for="fecha_activacion">Fecha Activación</label>
        <input type="date" id="fecha_activacion" name="fecha_activacion" value="<?= htmlspecialchars($empresa['fecha_activacion'] ?? '') ?>" />

        <button type="submit"><?= isset($empresa) ? 'Actualizar' : 'Crear' ?></button>
    </form>

    <a href="/empresa">Volver al listado</a>
</body>
</html>
