<?php
namespace Core\Controllers;

use Core\Classes\Auth;
use Core\Models\Banco;

class BancoController {
    private $auth;
    private $model;

    public function __construct() {
        $this->auth = new Auth();
        $this->model = new Banco();
    }

    public function index() {
        $this->checkAuth();
        $bancos = $this->model->getAll();
        require __DIR__ . '/../../views/banco/index.php';
    }

    public function create() {
        $this->checkAuth();
        require __DIR__ . '/../../views/banco/create.php';
    }

    public function store() {
        $this->checkAuth();
        $data = [
            'id' => $_POST['id'],
            'nombre' => $_POST['nombre'],
            'descripcion' => $_POST['descripcion'] ?? '',
            'pais' => $_POST['pais'] ?? 'Chile',
            'cod_sii' => $_POST['cod_sii'] ?? '',
            'codigo' => $_POST['codigo'] ?? '',
            'estado' => $_POST['estado'] ?? 'activo'
        ];
        if ($this->model->create($data)) {
            header('Location: /banco');
            exit;
        }
        $error = 'Error al crear banco';
        require __DIR__ . '/../../views/banco/create.php';
    }

    public function edit($id) {
        $this->checkAuth();
        $banco = $this->model->getById($id);
        if (!$banco) {
            header('Location: /banco');
            exit;
        }
        require __DIR__ . '/../../views/banco/edit.php';
    }

    public function update($id) {
        $this->checkAuth();
        $data = [
            'nombre' => $_POST['nombre'],
            'descripcion' => $_POST['descripcion'] ?? '',
            'pais' => $_POST['pais'] ?? 'Chile',
            'cod_sii' => $_POST['cod_sii'] ?? '',
            'codigo' => $_POST['codigo'] ?? '',
            'estado' => $_POST['estado'] ?? 'activo'
        ];
        if ($this->model->update($id, $data)) {
            header('Location: /banco');
            exit;
        }
        $error = 'Error al actualizar banco';
        $banco = $this->model->getById($id);
        require __DIR__ . '/../../views/banco/edit.php';
    }

    public function delete($id) {
        $this->checkAuth();
        $this->model->delete($id);
        header('Location: /banco');
        exit;
    }

    private function checkAuth() {
        if (!$this->auth->check()) {
            header('Location: /login');
            exit;
        }
    }
}
