<?php
namespace Core\Controllers;

use Core\Classes\Auth;
use Core\Models\Caso;

class CasoController {
    private $auth;
    private $model;

    public function __construct() {
        $this->auth = new Auth();
        $this->model = new Caso();
    }

    public function index() {
        $this->checkAuth();
        $empresa_id = $_SESSION['empresa_id'];
        $casos = $this->model->getAllByEmpresa($empresa_id);
        require __DIR__ . '/../../views/caso/index.php';
    }

    public function create() {
        $this->checkAuth();
        require __DIR__ . '/../../views/caso/create.php';
    }

    public function store() {
        $this->checkAuth();
        $data = [
            'empresa_id' => $_SESSION['empresa_id'],
            'cliente_id' => $_POST['cliente_id'],
            'tipo' => $_POST['tipo'],
            'estado' => 'pendiente',
            'asunto' => $_POST['asunto'],
            'descripcion' => $_POST['descripcion'],
            'creado_por' => $_SESSION['user_id']
        ];
        if ($this->model->create($data)) {
            header('Location: /caso');
            exit;
        }
        $error = 'Error al crear caso';
        require __DIR__ . '/../../views/caso/create.php';
    }

    public function edit($id) {
        $this->checkAuth();
        $caso = $this->model->getById($id);
        if (!$caso) {
            header('Location: /caso');
            exit;
        }
        require __DIR__ . '/../../views/caso/edit.php';
    }

    public function update($id) {
        $this->checkAuth();
        $data = [
            'tipo' => $_POST['tipo'],
            'estado' => $_POST['estado'],
            'asunto' => $_POST['asunto'],
            'descripcion' => $_POST['descripcion'],
            'asignado_a' => $_POST['asignado_a'] ?? null,
        ];
        if ($this->model->update($id, $data)) {
            header('Location: /caso');
            exit;
        }
        $error = 'Error al actualizar caso';
        $caso = $this->model->getById($id);
        require __DIR__ . '/../../views/caso/edit.php';
    }

    public function delete($id) {
        $this->checkAuth();
        $this->model->delete($id);
        header('Location: /caso');
        exit;
    }

    private function checkAuth() {
        if (!$this->auth->check()) {
            header('Location: /login');
            exit;
        }
    }
}
