<?php
namespace Core\Controllers;

use Core\Classes\Database;

class EmpresaController {
    private $db;

    public function __construct() {
        $this->db = Database::getInstance()->getConnection();
    }

    private function checkAuth() {
        if (!isset($_SESSION['user_id'])) {
            header('Location: /login');
            exit;
        }
    }

    public function index() {
        $this->checkAuth();
        $stmt = $this->db->query('SELECT * FROM empresas WHERE deleted_at IS NULL');
        $empresas = $stmt->fetchAll();
        require __DIR__ . '/../../views/empresa/index.php';
    }

    public function create() {
        $this->checkAuth();
        require __DIR__ . '/../../views/empresa/create.php';
    }

    public function store() {
        $this->checkAuth();
        
        $stmt = $this->db->prepare('INSERT INTO empresas (nombre, rut, direccion, telefono, email, created_at, updated_at) VALUES (?, ?, ?, ?, ?, NOW(), NOW())');
        
        if ($stmt->execute([
            $_POST['nombre'] ?? '',
            $_POST['rut'] ?? '',
            $_POST['direccion'] ?? '',
            $_POST['telefono'] ?? '',
            $_POST['email'] ?? ''
        ])) {
            header('Location: /empresa');
            exit;
        } else {
            $error = 'Error al crear la empresa';
            require __DIR__ . '/../../views/empresa/create.php';
        }
    }

    public function edit($id = null) {
        $this->checkAuth();
        
        $id = $id ?? $_GET['id'] ?? null;
        
        if (!$id) {
            header('Location: /empresa');
            exit;
        }
        
        $stmt = $this->db->prepare('SELECT * FROM empresas WHERE id = ? AND deleted_at IS NULL');
        $stmt->execute([$id]);
        $empresa = $stmt->fetch();
        
        if (!$empresa) {
            header('Location: /empresa');
            exit;
        }
        
        require __DIR__ . '/../../views/empresa/edit.php';
    }

    public function update($id = null) {
        $this->checkAuth();
        
        $id = $id ?? $_GET['id'] ?? null;
        
        if (!$id) {
            header('Location: /empresa');
            exit;
        }
        
        $stmt = $this->db->prepare('UPDATE empresas SET nombre = ?, rut = ?, direccion = ?, telefono = ?, email = ?, updated_at = NOW() WHERE id = ?');
        
        if ($stmt->execute([
            $_POST['nombre'] ?? '',
            $_POST['rut'] ?? '',
            $_POST['direccion'] ?? '',
            $_POST['telefono'] ?? '',
            $_POST['email'] ?? '',
            $id
        ])) {
            header('Location: /empresa');
            exit;
        } else {
            $error = 'Error al actualizar la empresa';
            $this->edit($id);
        }
    }

    public function delete($id = null) {
        $this->checkAuth();
        
        $id = $id ?? $_GET['id'] ?? null;
        
        if (!$id) {
            header('Location: /empresa');
            exit;
        }
        
        $stmt = $this->db->prepare('UPDATE empresas SET deleted_at = NOW() WHERE id = ?');
        
        if ($stmt->execute([$id])) {
            header('Location: /empresa');
            exit;
        } else {
            header('Location: /empresa?error=delete_failed');
            exit;
        }
    }
}
