<?php
namespace Core\Controllers;

use Core\Classes\Auth;
use Core\Models\PortalCliente;

class PortalClienteController {
    private $auth;
    private $model;

    public function __construct() {
        $this->auth = new Auth();
        $this->model = new PortalCliente();
    }

    public function index() {
        $this->checkAuth();
        $cliente_id = $_SESSION['cliente_id'];
        $reclamos = $this->model->obtenerReclamosPorCliente($cliente_id);
        require __DIR__ . '/../../views/portal_cliente/index.php';
    }

    public function nuevoReclamo() {
        $this->checkAuth();
        require __DIR__ . '/../../views/portal_cliente/nuevo_reclamo.php';
    }

    public function guardarReclamo() {
        $this->checkAuth();
        $data = [
            'empresa_id' => $_SESSION['empresa_id'],
            'cliente_id' => $_SESSION['cliente_id'],
            'asunto' => $_POST['asunto'],
            'descripcion' => $_POST['descripcion']
        ];
        if ($this->model->crearReclamo($data)) {
            header('Location: /portal_cliente');
            exit;
        }
        $error = 'Error al crear reclamo';
        require __DIR__ . '/../../views/portal_cliente/nuevo_reclamo.php';
    }

    private function checkAuth() {
        if (!$this->auth->check()) {
            header('Location: /login');
            exit;
        }
    }
}
