<?php
namespace Core\Models;

use Core\Classes\Database;

class Documento {
    private $db;

    public function __construct() {
        $this->db = Database::getInstance()->getConnection();
    }

    public function getAllByEmpresa($empresa_id) {
        $stmt = $this->db->prepare('SELECT * FROM documentos WHERE empresa_id = ? AND deleted_at IS NULL ORDER BY fecha_subida DESC');
        $stmt->execute([$empresa_id]);
        return $stmt->fetchAll();
    }

    public function getById($id) {
        $stmt = $this->db->prepare('SELECT * FROM documentos WHERE id = ? AND deleted_at IS NULL');
        $stmt->execute([$id]);
        return $stmt->fetch();
    }

    public function create($data) {
        $stmt = $this->db->prepare('INSERT INTO documentos (empresa_id, nombre, descripcion, tipo, archivo, fecha_subida, creado_por) VALUES (?, ?, ?, ?, ?, NOW(), ?)');
        return $stmt->execute([
            $data['empresa_id'],
            $data['nombre'],
            $data['descripcion'],
            $data['tipo'],
            $data['archivo'],
            $data['creado_por']
        ]);
    }

    public function update($id, $data) {
        $stmt = $this->db->prepare('UPDATE documentos SET nombre = ?, descripcion = ?, tipo = ?, archivo = ?, actualizado_por = ?, fecha_actualizacion = NOW() WHERE id = ?');
        return $stmt->execute([
            $data['nombre'],
            $data['descripcion'],
            $data['tipo'],
            $data['archivo'],
            $data['actualizado_por'],
            $id
        ]);
    }

    public function delete($id) {
        $stmt = $this->db->prepare('UPDATE documentos SET deleted_at = NOW() WHERE id = ?');
        return $stmt->execute([$id]);
    }
}
