<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Editar Banco</title>
    <link rel="stylesheet" href="/public/css/style.css" />
</head>
<body>
    <h1>Editar Banco #<?= htmlspecialchars($banco['id']) ?></h1>

    <?php if (isset($error)): ?>
        <p class="error"><?= htmlspecialchars($error) ?></p>
    <?php endif; ?>

    <form method="POST" action="/banco/update/<?= $banco['id'] ?>">
        <label for="nombre">Nombre</label>
        <input type="text" id="nombre" name="nombre" value="<?= htmlspecialchars($banco['nombre']) ?>" required />

        <label for="descripcion">Descripción</label>
        <textarea id="descripcion" name="descripcion"><?= htmlspecialchars($banco['descripcion']) ?></textarea>

        <label for="pais">País</label>
        <input type="text" id="pais" name="pais" value="<?= htmlspecialchars($banco['pais']) ?>" />

        <label for="cod_sii">Código SII</label>
        <input type="text" id="cod_sii" name="cod_sii" value="<?= htmlspecialchars($banco['cod_sii']) ?>" />

        <label for="codigo">Código</label>
        <input type="text" id="codigo" name="codigo" value="<?= htmlspecialchars($banco['codigo']) ?>" />

        <label for="estado">Estado</label>
        <select id="estado" name="estado">
            <option value="activo" <?= $banco['estado'] === 'activo' ? 'selected' : '' ?>>Activo</option>
            <option value="inactivo" <?= $banco['estado'] === 'inactivo' ? 'selected' : '' ?>>Inactivo</option>
        </select>

        <button type="submit">Actualizar Banco</button>
    </form>

    <a href="/banco">Volver al listado</a>
</body>
</html>
