<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Listado de Bancos</title>
    <link rel="stylesheet" href="/public/css/style.css" />
</head>
<body>
    <h1>Bancos</h1>
    <a href="/banco/create">Crear Nuevo Banco</a>
    <table border="1" cellpadding="5" cellspacing="0">
        <thead>
            <tr>
                <th>ID</th>
                <th>Nombre</th>
                <th>País</th>
                <th>Estado</th>
                <th>Acciones</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($bancos as $banco): ?>
            <tr>
                <td><?= htmlspecialchars($banco['id']) ?></td>
                <td><?= htmlspecialchars($banco['nombre']) ?></td>
                <td><?= htmlspecialchars($banco['pais']) ?></td>
                <td><?= htmlspecialchars($banco['estado']) ?></td>
                <td>
                    <a href="/banco/edit/<?= $banco['id'] ?>">Editar</a> |
                    <a href="/banco/delete/<?= $banco['id'] ?>" onclick="return confirm('¿Confirmar eliminación?')">Eliminar</a>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</body>
</html>
