<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Categorías</title>
    <link rel="stylesheet" href="/public/css/style.css" />
</head>
<body>
    <h1>Categorías</h1>
    <a href="/categoria/create">Nueva Categoría</a>
    <table border="1" cellpadding="5" cellspacing="0">
        <thead>
            <tr>
                <th>ID</th>
                <th>Nombre</th>
                <th>Descripción</th>
                <th>Estado</th>
                <th>Acciones</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($categorias as $cat): ?>
            <tr>
                <td><?= htmlspecialchars($cat['id']) ?></td>
                <td><?= htmlspecialchars($cat['nombre']) ?></td>
                <td><?= htmlspecialchars($cat['descripcion']) ?></td>
                <td><?= htmlspecialchars($cat['estado']) ?></td>
                <td>
                    <a href="/categoria/edit/<?= $cat['id'] ?>">Editar</a> |
                    <a href="/categoria/delete/<?= $cat['id'] ?>" onclick="return confirm('¿Confirmar eliminación?')">Eliminar</a>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</body>
</html>
