<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Editar Cliente</title>
    <link rel="stylesheet" href="/public/css/style.css" />
</head>
<body>
    <h1>Editar Cliente #<?= htmlspecialchars($cliente['id']) ?></h1>

    <?php if (isset($error)): ?>
        <p class="error"><?= htmlspecialchars($error) ?></p>
    <?php endif; ?>

    <form method="POST" action="/cliente/update/<?= $cliente['id'] ?>">
        <label for="rut">RUT</label>
        <input type="text" id="rut" name="rut" value="<?= htmlspecialchars($cliente['rut']) ?>" required />

        <label for="nombres">Nombres</label>
        <input type="text" id="nombres" name="nombres" value="<?= htmlspecialchars($cliente['nombres']) ?>" required />

        <label for="apellidos">Apellidos</label>
        <input type="text" id="apellidos" name="apellidos" value="<?= htmlspecialchars($cliente['apellidos']) ?>" required />

        <label for="correo">Correo</label>
        <input type="email" id="correo" name="correo" value="<?= htmlspecialchars($cliente['correo']) ?>" />

        <label for="telefono">Teléfono</label>
        <input type="text" id="telefono" name="telefono" value="<?= htmlspecialchars($cliente['telefono']) ?>" />

        <label for="direccion">Dirección</label>
        <input type="text" id="direccion" name="direccion" value="<?= htmlspecialchars($cliente['direccion']) ?>" />

        <label for="estado">Estado</label>
        <select id="estado" name="estado">
            <option value="activo" <?= $cliente['estado'] === 'activo' ? 'selected' : '' ?>>Activo</option>
            <option value="inactivo" <?= $cliente['estado'] === 'inactivo' ? 'selected' : '' ?>>Inactivo</option>
        </select>

        <button type="submit">Actualizar Cliente</button>
    </form>

    <a href="/cliente">Volver al listado</a>
</body>
</html>
