<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard SSR</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #f5f7fa;
        }
        
        /* Sidebar */
        .sidebar {
            position: fixed;
            left: 0;
            top: 0;
            width: 260px;
            height: 100vh;
            background: linear-gradient(180deg, #667eea 0%, #764ba2 100%);
            color: white;
            overflow-y: auto;
            z-index: 1000;
            box-shadow: 2px 0 10px rgba(0,0,0,0.1);
        }
        .sidebar::-webkit-scrollbar {
            width: 6px;
        }
        .sidebar::-webkit-scrollbar-track {
            background: rgba(0,0,0,0.1);
        }
        .sidebar::-webkit-scrollbar-thumb {
            background: rgba(255,255,255,0.3);
            border-radius: 3px;
        }
        .sidebar-header {
            padding: 25px 20px;
            background: rgba(0,0,0,0.2);
            border-bottom: 1px solid rgba(255,255,255,0.1);
        }
        .sidebar-header h2 {
            font-size: 20px;
            margin-bottom: 5px;
            font-weight: 600;
        }
        .sidebar-header .user-info {
            font-size: 13px;
            opacity: 0.9;
            margin-top: 8px;
        }
        .sidebar-header .user-role {
            display: inline-block;
            background: rgba(255,255,255,0.2);
            padding: 3px 10px;
            border-radius: 12px;
            font-size: 11px;
            margin-top: 8px;
            text-transform: uppercase;
            font-weight: 600;
        }
        .sidebar-menu {
            padding: 20px 0;
        }
        .menu-section {
            margin-bottom: 25px;
        }
        .menu-section-title {
            padding: 10px 20px;
            font-size: 11px;
            text-transform: uppercase;
            opacity: 0.7;
            font-weight: 600;
            letter-spacing: 0.5px;
        }
        .menu-item {
            display: flex;
            align-items: center;
            padding: 12px 20px;
            color: white;
            text-decoration: none;
            transition: all 0.3s;
            border-left: 3px solid transparent;
        }
        .menu-item:hover {
            background: rgba(255,255,255,0.1);
            padding-left: 25px;
            border-left-color: rgba(255,255,255,0.5);
        }
        .menu-item i {
            width: 25px;
            font-size: 16px;
            margin-right: 12px;
        }
        .menu-item.active {
            background: rgba(255,255,255,0.15);
            border-left-color: #fff;
            font-weight: 600;
        }
        
        /* Main content */
        .main-content {
            margin-left: 260px;
            min-height: 100vh;
        }
        .topbar {
            background: white;
            padding: 15px 30px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
            display: flex;
            justify-content: space-between;
            align-items: center;
            position: sticky;
            top: 0;
            z-index: 100;
        }
        .topbar h1 {
            font-size: 24px;
            color: #333;
            font-weight: 600;
        }
        .topbar-actions {
            display: flex;
            gap: 15px;
            align-items: center;
        }
        .notification-btn {
            position: relative;
            padding: 8px 12px;
            background: #f5f7fa;
            border-radius: 8px;
            color: #667eea;
            cursor: pointer;
            transition: all 0.3s;
        }
        .notification-btn:hover {
            background: #e8eaf6;
        }
        .notification-badge {
            position: absolute;
            top: 2px;
            right: 2px;
            background: #e74c3c;
            color: white;
            font-size: 10px;
            padding: 2px 5px;
            border-radius: 10px;
            font-weight: bold;
        }
        .logout-btn {
            padding: 8px 20px;
            background: #e74c3c;
            color: white;
            text-decoration: none;
            border-radius: 8px;
            font-size: 14px;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            transition: all 0.3s;
        }
        .logout-btn:hover {
            background: #c0392b;
            transform: translateY(-1px);
            box-shadow: 0 4px 8px rgba(231, 76, 60, 0.3);
        }
        
        /* Content area */
        .content {
            padding: 30px;
        }
        .welcome-card {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 30px;
            border-radius: 15px;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
            margin-bottom: 30px;
        }
        .welcome-card h2 {
            font-size: 28px;
            margin-bottom: 10px;
        }
        .welcome-card p {
            opacity: 0.9;
            font-size: 16px;
        }
        
        /* Stats Grid */
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        .stat-card {
            background: white;
            padding: 25px;
            border-radius: 12px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
            border-left: 4px solid #667eea;
            transition: all 0.3s;
            position: relative;
            overflow: hidden;
        }
        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 20px rgba(0,0,0,0.1);
        }
        .stat-card::before {
            content: '';
            position: absolute;
            top: 0;
            right: 0;
            width: 100px;
            height: 100px;
            background: linear-gradient(135deg, transparent, rgba(102, 126, 234, 0.05));
            border-radius: 0 0 0 100%;
        }
        .stat-label {
            font-size: 12px;
            color: #666;
            text-transform: uppercase;
            font-weight: 600;
            margin-bottom: 10px;
            letter-spacing: 0.5px;
        }
        .stat-value {
            font-size: 32px;
            font-weight: bold;
            color: #333;
            margin-bottom: 5px;
        }
        .stat-change {
            font-size: 12px;
            color: #27ae60;
            font-weight: 600;
        }
        .stat-change.negative {
            color: #e74c3c;
        }
        .stat-icon {
            position: absolute;
            right: 20px;
            top: 50%;
            transform: translateY(-50%);
            font-size: 48px;
            color: #667eea;
            opacity: 0.15;
        }
        
        /* Quick Actions */
        .quick-actions {
            background: white;
            padding: 25px;
            border-radius: 12px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
            margin-bottom: 30px;
        }
        .quick-actions h3 {
            margin-bottom: 20px;
            color: #333;
            font-size: 18px;
        }
        .actions-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
        }
        .action-btn {
            display: flex;
            align-items: center;
            padding: 15px 20px;
            background: #f8f9fa;
            border-radius: 10px;
            text-decoration: none;
            color: #333;
            transition: all 0.3s;
            border: 2px solid transparent;
        }
        .action-btn:hover {
            background: #667eea;
            color: white;
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(102, 126, 234, 0.3);
        }
        .action-btn i {
            font-size: 24px;
            margin-right: 15px;
            width: 40px;
            height: 40px;
            display: flex;
            align-items: center;
            justify-content: center;
            background: white;
            border-radius: 8px;
        }
        .action-btn:hover i {
            background: rgba(255,255,255,0.2);
        }
        
        /* Recent Activity */
        .recent-activity {
            background: white;
            padding: 25px;
            border-radius: 12px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        }
        .recent-activity h3 {
            margin-bottom: 20px;
            color: #333;
            font-size: 18px;
        }
        .activity-item {
            padding: 15px;
            border-left: 3px solid #667eea;
            margin-bottom: 15px;
            background: #f8f9fa;
            border-radius: 8px;
        }
        .activity-item:last-child {
            margin-bottom: 0;
        }
        .activity-time {
            font-size: 12px;
            color: #999;
            margin-bottom: 5px;
        }
        .activity-text {
            color: #333;
            font-size: 14px;
        }
        
        /* Responsive */
        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
                transition: transform 0.3s;
            }
            .sidebar.active {
                transform: translateX(0);
            }
            .main-content {
                margin-left: 0;
            }
            .stats-grid {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <!-- Sidebar -->
    <div class="sidebar">
        <div class="sidebar-header">
            <h2><i class="fas fa-water"></i> SG-SSR</h2>
            <div class="user-info">
                <?= htmlspecialchars($_SESSION['user_name']) ?>
            </div>
            <span class="user-role"><?= htmlspecialchars($_SESSION['user_role']) ?></span>
        </div>
        
        <div class="sidebar-menu">
            <!-- Principal -->
            <div class="menu-section">
                <div class="menu-section-title">Principal</div>
                <a href="/dashboard" class="menu-item active">
                    <i class="fas fa-home"></i>
                    <span>Dashboard</span>
                </a>
            </div>
            
            <!-- Contactabilidad -->
            <div class="menu-section">
                <div class="menu-section-title">Contactabilidad</div>
                <a href="/contactabilidad" class="menu-item">
                    <i class="fas fa-phone-volume"></i>
                    <span>Gestión</span>
                </a>
                <a href="/caso" class="menu-item">
                    <i class="fas fa-folder-open"></i>
                    <span>Casos</span>
                </a>
                <a href="/cliente" class="menu-item">
                    <i class="fas fa-users"></i>
                    <span>Clientes</span>
                </a>
                <a href="/seguimiento" class="menu-item">
                    <i class="fas fa-tasks"></i>
                    <span>Seguimiento</span>
                </a>
                <a href="/respuesta" class="menu-item">
                    <i class="fas fa-reply"></i>
                    <span>Respuestas</span>
                </a>
            </div>
            
            <!-- Administración -->
            <div class="menu-section">
                <div class="menu-section-title">Administración</div>
                <a href="/empresa" class="menu-item">
                    <i class="fas fa-building"></i>
                    <span>Empresas</span>
                </a>
                <a href="/usuario" class="menu-item">
                    <i class="fas fa-user-cog"></i>
                    <span>Usuarios</span>
                </a>
                <a href="/categoria" class="menu-item">
                    <i class="fas fa-tags"></i>
                    <span>Categorías</span>
                </a>
            </div>
            
            <!-- Finanzas -->
            <div class="menu-section">
                <div class="menu-section-title">Finanzas</div>
                <a href="/tesoreria" class="menu-item">
                    <i class="fas fa-dollar-sign"></i>
                    <span>Tesorería</span>
                </a>
                <a href="/proveedor" class="menu-item">
                    <i class="fas fa-truck"></i>
                    <span>Proveedores</span>
                </a>
                <a href="/banco" class="menu-item">
                    <i class="fas fa-university"></i>
                    <span>Bancos</span>
                </a>
            </div>
            
            <!-- Reportes y Documentos -->
            <div class="menu-section">
                <div class="menu-section-title">Reportes</div>
                <a href="/reporte" class="menu-item">
                    <i class="fas fa-chart-bar"></i>
                    <span>Informes</span>
                </a>
                <a href="/documento" class="menu-item">
                    <i class="fas fa-file-alt"></i>
                    <span>Documentos</span>
                </a>
                <a href="/log" class="menu-item">
                    <i class="fas fa-history"></i>
                    <span>Auditoría</span>
                </a>
            </div>
            
            <!-- Herramientas -->
            <div class="menu-section">
                <div class="menu-section-title">Herramientas</div>
                <a href="/portal" class="menu-item">
                    <i class="fas fa-globe"></i>
                    <span>Portal Cliente</span>
                </a>
                <a href="/notificacion" class="menu-item">
                    <i class="fas fa-bell"></i>
                    <span>Notificaciones</span>
                </a>
                <a href="/backup" class="menu-item">
                    <i class="fas fa-database"></i>
                    <span>Respaldo</span>
                </a>
            </div>
        </div>
    </div>
    
    <!-- Main Content -->
    <div class="main-content">
        <div class="topbar">
            <h1><i class="fas fa-chart-line"></i> Dashboard</h1>
            <div class="topbar-actions">
                <div class="notification-btn">
                    <i class="fas fa-bell"></i>
                    <span class="notification-badge">3</span>
                </div>
                <a href="/logout" class="logout-btn">
                    <i class="fas fa-sign-out-alt"></i>
                    Cerrar Sesión
                </a>
            </div>
        </div>
        
        <div class="content">
            <!-- Welcome Card -->
            <div class="welcome-card">
                <h2>¡Bienvenido, <?= htmlspecialchars(explode(' ', $_SESSION['user_name'])[0]) ?>!</h2>
                <p>Sistema de Gestión para Servicios Sanitarios Rurales - Empresa ID: <?= htmlspecialchars($_SESSION['empresa_id']) ?></p>
            </div>
            
            <!-- Stats Grid -->
            <div class="stats-grid">
                <div class="stat-card">
                    <i class="fas fa-users stat-icon"></i>
                    <div class="stat-label">Total Clientes</div>
                    <div class="stat-value">247</div>
                    <div class="stat-change"><i class="fas fa-arrow-up"></i> +12% este mes</div>
                </div>
                
                <div class="stat-card">
                    <i class="fas fa-phone stat-icon"></i>
                    <div class="stat-label">Casos Activos</div>
                    <div class="stat-value">18</div>
                    <div class="stat-change"><i class="fas fa-arrow-down"></i> -5% esta semana</div>
                </div>
                
                <div class="stat-card">
                    <i class="fas fa-check-circle stat-icon"></i>
                    <div class="stat-label">Casos Resueltos</div>
                    <div class="stat-value">342</div>
                    <div class="stat-change"><i class="fas fa-arrow-up"></i> +8% este mes</div>
                </div>
                
                <div class="stat-card">
                    <i class="fas fa-dollar-sign stat-icon"></i>
                    <div class="stat-label">Ingresos Mes</div>
                    <div class="stat-value">$2.5M</div>
                    <div class="stat-change"><i class="fas fa-arrow-up"></i> +15% vs mes anterior</div>
                </div>
            </div>
            
            <!-- Quick Actions -->
            <div class="quick-actions">
                <h3><i class="fas fa-bolt"></i> Acciones Rápidas</h3>
                <div class="actions-grid">
                    <a href="/contactabilidad/create" class="action-btn">
                        <i class="fas fa-plus-circle"></i>
                        <span>Nuevo Caso</span>
                    </a>
                    <a href="/cliente/create" class="action-btn">
                        <i class="fas fa-user-plus"></i>
                        <span>Nuevo Cliente</span>
                    </a>
                    <a href="/reporte" class="action-btn">
                        <i class="fas fa-file-download"></i>
                        <span>Generar Reporte</span>
                    </a>
                    <a href="/backup/create" class="action-btn">
                        <i class="fas fa-save"></i>
                        <span>Crear Respaldo</span>
                    </a>
                </div>
            </div>
            
            <!-- Recent Activity -->
            <div class="recent-activity">
                <h3><i class="fas fa-clock"></i> Actividad Reciente</h3>
                <div class="activity-item">
                    <div class="activity-time"><i class="fas fa-clock"></i> Hace 5 minutos</div>
                    <div class="activity-text">Nuevo caso registrado: Fuga de agua en sector norte</div>
                </div>
                <div class="activity-item">
                    <div class="activity-time"><i class="fas fa-clock"></i> Hace 23 minutos</div>
                    <div class="activity-text">Cliente nuevo registrado: Juan Pérez González</div>
                </div>
                <div class="activity-item">
                    <div class="activity-time"><i class="fas fa-clock"></i> Hace 1 hora</div>
                    <div class="activity-text">Caso #2847 cerrado exitosamente</div>
                </div>
                <div class="activity-item">
                    <div class="activity-time"><i class="fas fa-clock"></i> Hace 2 horas</div>
                    <div class="activity-text">Respaldo automático completado</div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
