<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Empresas</title>
    <style>
        body { font-family: Arial, sans-serif; padding: 20px; }
        h1 { color: #333; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        th, td { padding: 12px; text-align: left; border: 1px solid #ddd; }
        th { background: #667eea; color: white; }
        tr:hover { background: #f5f5f5; }
        .btn { padding: 8px 16px; background: #667eea; color: white; text-decoration: none; border-radius: 4px; }
        .btn:hover { background: #5568d3; }
        .btn-delete { background: #e74c3c; }
    </style>
</head>
<body>
    <h1>Listado de Empresas</h1>
    <a href="/empresa/create" class="btn">Crear Nueva Empresa</a>
    
    <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>RUT</th>
                <?php 
                // Detectar columnas disponibles dinámicamente
                if (!empty($empresas)) {
                    $columnas = array_keys($empresas[0]);
                    foreach ($columnas as $col) {
                        if (!in_array($col, ['id', 'rut', 'created_at', 'updated_at', 'deleted_at'])) {
                            echo "<th>" . ucfirst(str_replace('_', ' ', $col)) . "</th>";
                        }
                    }
                }
                ?>
                <th>Acciones</th>
            </tr>
        </thead>
        <tbody>
            <?php if (empty($empresas)): ?>
                <tr>
                    <td colspan="10" style="text-align: center;">No hay empresas registradas</td>
                </tr>
            <?php else: ?>
                <?php foreach ($empresas as $empresa): ?>
                    <tr>
                        <td><?= htmlspecialchars($empresa['id'] ?? '') ?></td>
                        <td><?= htmlspecialchars($empresa['rut'] ?? '') ?></td>
                        <?php 
                        $columnas = array_keys($empresa);
                        foreach ($columnas as $col) {
                            if (!in_array($col, ['id', 'rut', 'created_at', 'updated_at', 'deleted_at'])) {
                                echo "<td>" . htmlspecialchars($empresa[$col] ?? '') . "</td>";
                            }
                        }
                        ?>
                        <td>
                            <a href="/empresa/edit/<?= $empresa['id'] ?>">Editar</a> | 
                            <a href="/empresa/delete/<?= $empresa['id'] ?>" onclick="return confirm('¿Estás seguro?')">Eliminar</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php endif; ?>
        </tbody>
    </table>
    
    <br>
    <a href="/dashboard">Volver al Dashboard</a>
</body>
</html>
