<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Editar Usuario</title>
    <link rel="stylesheet" href="/public/css/style.css" />
</head>
<body>
    <h1>Editar Usuario #<?= htmlspecialchars($usuario['id']) ?></h1>

    <?php if (isset($error)): ?>
        <p class="error"><?= htmlspecialchars($error) ?></p>
    <?php endif; ?>

    <form method="POST" action="/usuario/update/<?= $usuario['id'] ?>">
        <label for="rut">RUT</label>
        <input type="text" id="rut" name="rut" value="<?= htmlspecialchars($usuario['rut']) ?>" required />

        <label for="nombres">Nombres</label>
        <input type="text" id="nombres" name="nombres" value="<?= htmlspecialchars($usuario['nombres']) ?>" required />

        <label for="apellidos">Apellidos</label>
        <input type="text" id="apellidos" name="apellidos" value="<?= htmlspecialchars($usuario['apellidos']) ?>" required />

        <label for="email">Email</label>
        <input type="email" id="email" name="email" value="<?= htmlspecialchars($usuario['email']) ?>" required />

        <label for="telefono">Teléfono</label>
        <input type="text" id="telefono" name="telefono" value="<?= htmlspecialchars($usuario['telefono']) ?>" />

        <label for="rol">Rol</label>
        <select id="rol" name="rol">
            <option value="cliente" <?= $usuario['rol'] === 'cliente' ? 'selected' : '' ?>>Cliente</option>
            <option value="administrador" <?= $usuario['rol'] === 'administrador' ? 'selected' : '' ?>>Administrador</option>
            <option value="usuario" <?= $usuario['rol'] === 'usuario' ? 'selected' : '' ?>>Usuario</option>
        </select>

        <label for="estado">Estado</label>
        <select id="estado" name="estado">
            <option value="activo" <?= $usuario['estado'] === 'activo' ? 'selected' : '' ?>>Activo</option>
            <option value="inactivo" <?= $usuario['estado'] === 'inactivo' ? 'selected' : '' ?>>Inactivo</option>
        </select>

        <button type="submit">Actualizar Usuario</button>
    </form>

    <a href="/usuario">Volver al listado</a>
</body>
</html>
