<?php

namespace Core\Classes;

use PDO;
use PDOException;

class Database {
    private static $instance = null;
    private $connection;

    private function __construct() {
        try {
            $dsn = 'mysql:host=' . DB_HOST . ';dbname=' . DB_NAME . ';charset=' . DB_CHARSET;
            $this->connection = new PDO($dsn, DB_USER, DB_PASS, DB_OPTIONS);
        } catch (PDOException $e) {
            die('Error de conexión a BD: ' . $e->getMessage());
        }
    }

    // Evitar clonar
    private function __clone() {}

    // Obtener instancia singleton
    public static function getInstance() {
        if (self::$instance === null) {
            self::$instance = new Database();
        }
        return self::$instance;
    }

    // Acceder a la conexión PDO
    public function getConnection() {
        return $this->connection;
    }
}

