<?php
namespace Core\Controllers;

use Core\Classes\Auth;
use Core\Models\Respuesta;

class RespuestaController {
    private $auth;
    private $model;

    public function __construct() {
        $this->auth = new Auth();
        $this->model = new Respuesta();
    }

    public function index($caso_id) {
        $this->checkAuth();
        $respuestas = $this->model->getAllByCaso($caso_id);
        require __DIR__ . '/../../views/respuesta/index.php';
    }

    public function store() {
        $this->checkAuth();
        $data = [
            'caso_id' => $_POST['caso_id'],
            'usuario_id' => $_SESSION['user_id'],
            'texto' => $_POST['texto']
        ];
        if ($this->model->create($data)) {
            header('Location: /respuesta/index/' . $data['caso_id']);
            exit;
        }
        $error = 'Error al agregar respuesta';
        require __DIR__ . '/../../views/respuesta/create.php';
    }

    private function checkAuth() {
        if (!$this->auth->check()) {
            header('Location: /login');
            exit;
        }
    }
}
