<?php
namespace Core\Controllers;

use Core\Classes\Auth;
use Core\Models\Usuario;

class UsuarioController {
    private $auth;
    private $model;

    public function __construct() {
        $this->auth = new Auth();
        $this->model = new Usuario();
    }

    // ... Métodos anteriores, login, logout, etc ...

    public function index() {
        $this->checkAuth();
        $usuarios = $this->model->getAll();
        $vista = defined('BASE_PATH') ? BASE_PATH . '/views/usuario/index.php' : __DIR__ . '/../../views/usuario/index.php';
        require $vista;
    }

    public function create() {
        $this->checkAuth();
        $vista = defined('BASE_PATH') ? BASE_PATH . '/views/usuario/create.php' : __DIR__ . '/../../views/usuario/create.php';
        require $vista;
    }

    public function store() {
        $this->checkAuth();

        // Obtiene empresa_id que el usuario intenta asignar
        $posted_empresa_id = $_POST['empresa_id'] ?? null;
        $user_role = $_SESSION['user_role'] ?? '';

        // Validar que admin empresa sólo cree usuarios en su empresa
        if ($user_role === 'admin_empresa' && $posted_empresa_id != $_SESSION['empresa_id']) {
            die("Error: No tienes permiso para crear usuarios en otra empresa.");
        }
        
        $data = [
            'empresa_id' => $posted_empresa_id ?? $_SESSION['empresa_id'],
            'rut' => $_POST['rut'] ?? '',
            'nombres' => $_POST['nombres'] ?? '',
            'apellidos' => $_POST['apellidos'] ?? '',
            'email' => $_POST['email'] ?? '',
            'password' => $_POST['password'] ?? '',
            'telefono' => $_POST['telefono'] ?? '',
            'rol' => $_POST['rol'] ?? 'cliente',
            'estado' => 'activo'
        ];
        
        if ($this->model->create($data)) {
            header('Location: /usuario');
            exit;
        }
        
        $error = 'Error al crear usuario';
        $vista = defined('BASE_PATH') ? BASE_PATH . '/views/usuario/create.php' : __DIR__ . '/../../views/usuario/create.php';
        require $vista;
    }

    public function edit($id) {
        $this->checkAuth();
        
        $usuario = $this->model->getById($id);
        if (!$usuario) {
            header('Location: /usuario');
            exit;
        }

        // Validar que admin empresa solo edite usuarios de su empresa
        $user_role = $_SESSION['user_role'] ?? '';
        if ($user_role === 'admin_empresa' && $usuario['empresa_id'] != $_SESSION['empresa_id']) {
            die("Error: No tienes permiso para editar usuarios de otra empresa.");
        }
        
        $vista = defined('BASE_PATH') ? BASE_PATH . '/views/usuario/edit.php' : __DIR__ . '/../../views/usuario/edit.php';
        require $vista;
    }

    public function update($id) {
        $this->checkAuth();

        $usuario_actual = $this->model->getById($id);
        if (!$usuario_actual) {
            die("Error: Usuario no encontrado.");
        }

        // Validar empresa para admin empresa
        $user_role = $_SESSION['user_role'] ?? '';
        if ($user_role === 'admin_empresa' && $usuario_actual['empresa_id'] != $_SESSION['empresa_id']) {
            die("Error: No tienes permiso para actualizar usuarios de otra empresa.");
        }
        
        $data = [
            'rut' => $_POST['rut'] ?? '',
            'nombres' => $_POST['nombres'] ?? '',
            'apellidos' => $_POST['apellidos'] ?? '',
            'email' => $_POST['email'] ?? '',
            'telefono' => $_POST['telefono'] ?? '',
            'rol' => $_POST['rol'] ?? 'cliente',
            'estado' => $_POST['estado'] ?? 'activo'
        ];
        
        if (!empty($_POST['password'])) {
            $data['password'] = $_POST['password'];
        }
        
        if ($this->model->update($id, $data)) {
            header('Location: /usuario');
            exit;
        }
        
        $error = 'Error al actualizar usuario';
        $usuario = $this->model->getById($id);
        $vista = defined('BASE_PATH') ? BASE_PATH . '/views/usuario/edit.php' : __DIR__ . '/../../views/usuario/edit.php';
        require $vista;
    }

    public function delete($id) {
        $this->checkAuth();

        $usuario = $this->model->getById($id);
        if (!$usuario) {
            die("Error: Usuario no encontrado.");
        }

        $user_role = $_SESSION['user_role'] ?? '';
        if ($user_role === 'admin_empresa' && $usuario['empresa_id'] != $_SESSION['empresa_id']) {
            die("Error: No tienes permiso para eliminar usuarios de otra empresa.");
        }

        $this->model->delete($id);
        header('Location: /usuario');
        exit;
    }

    private function checkAuth() {
        if (!$this->auth->check()) {
            header('Location: /login');
            exit;
        }
    }
}
