<?php
namespace Core\Models;

use Core\Classes\Database;

class Categoria {
    private $db;

    public function __construct() {
        $this->db = Database::getInstance()->getConnection();
    }

    public function getAllByEmpresa($empresa_id) {
        $stmt = $this->db->prepare('SELECT * FROM categorias WHERE empresa_id = ? AND deleted_at IS NULL ORDER BY nombre ASC');
        $stmt->execute([$empresa_id]);
        return $stmt->fetchAll();
    }

    public function getById($id) {
        $stmt = $this->db->prepare('SELECT * FROM categorias WHERE id = ? AND deleted_at IS NULL');
        $stmt->execute([$id]);
        return $stmt->fetch();
    }

    public function create($data) {
        $stmt = $this->db->prepare('INSERT INTO categorias (empresa_id, nombre, descripcion, estado, fecha_creacion) VALUES (?, ?, ?, ?, NOW())');
        return $stmt->execute([
            $data['empresa_id'],
            $data['nombre'],
            $data['descripcion'] ?? '',
            $data['estado'] ?? 'activo'
        ]);
    }

    public function update($id, $data) {
        $stmt = $this->db->prepare('UPDATE categorias SET nombre = ?, descripcion = ?, estado = ? WHERE id = ?');
        return $stmt->execute([
            $data['nombre'],
            $data['descripcion'] ?? '',
            $data['estado'] ?? 'activo',
            $id
        ]);
    }

    public function delete($id) {
        $stmt = $this->db->prepare('UPDATE categorias SET deleted_at = NOW() WHERE id = ?');
        return $stmt->execute([$id]);
    }
}
