<?php
namespace Core\Models;

use Core\Classes\Database;

class Cliente {
    private $db;

    public function __construct() {
        $this->db = Database::getInstance()->getConnection();
    }

    public function getAllByEmpresa($empresa_id) {
        $stmt = $this->db->prepare('SELECT * FROM clientes WHERE empresa_id = ? AND deleted_at IS NULL ORDER BY nombres ASC, apellidos ASC');
        $stmt->execute([$empresa_id]);
        return $stmt->fetchAll();
    }

    public function getById($id) {
        $stmt = $this->db->prepare('SELECT * FROM clientes WHERE id = ? AND deleted_at IS NULL');
        $stmt->execute([$id]);
        return $stmt->fetch();
    }

    public function create($data) {
        $stmt = $this->db->prepare('INSERT INTO clientes (empresa_id, rut, nombres, apellidos, correo, telefono, direccion, estado, fecha_registro) VALUES (?, ?, ?, ?, ?, ?, ?, ?, NOW())');
        return $stmt->execute([
            $data['empresa_id'],
            $data['rut'],
            $data['nombres'],
            $data['apellidos'],
            $data['correo'] ?? '',
            $data['telefono'] ?? '',
            $data['direccion'] ?? '',
            $data['estado'] ?? 'activo'
        ]);
    }

    public function update($id, $data) {
        $stmt = $this->db->prepare('UPDATE clientes SET rut = ?, nombres = ?, apellidos = ?, correo = ?, telefono = ?, direccion = ?, estado = ? WHERE id = ?');
        return $stmt->execute([
            $data['rut'],
            $data['nombres'],
            $data['apellidos'],
            $data['correo'] ?? '',
            $data['telefono'] ?? '',
            $data['direccion'] ?? '',
            $data['estado'],
            $id
        ]);
    }

    public function delete($id) {
        $stmt = $this->db->prepare('UPDATE clientes SET deleted_at = NOW() WHERE id = ?');
        return $stmt->execute([$id]);
    }
}
