<?php
namespace Core\Models;

use Core\Classes\Database;

class ContactabilidadCaso {
    private $db;

    public function __construct() {
        $this->db = Database::getInstance()->getConnection();
    }

    // Listar casos de una empresa específica
    public function getByEmpresa($empresa_id) {
        $stmt = $this->db->prepare('SELECT * FROM contactabilidad_casos WHERE empresa_id = ? AND deleted_at IS NULL');
        $stmt->execute([$empresa_id]);
        return $stmt->fetchAll();
    }

    // Obtener caso por ID
    public function getById($id) {
        $stmt = $this->db->prepare('SELECT * FROM contactabilidad_casos WHERE id = ? AND deleted_at IS NULL');
        $stmt->execute([$id]);
        return $stmt->fetch();
    }

    // Crear nuevo caso
    public function create($data) {
        $stmt = $this->db->prepare('INSERT INTO contactabilidad_casos (empresa_id, cliente_id, tipo, estado, asunto, descripcion, fecha_creacion, creado_por) VALUES (?, ?, ?, ?, ?, ?, NOW(), ?)');
        return $stmt->execute([
            $data['empresa_id'],
            $data['cliente_id'],
            $data['tipo'],
            $data['estado'] ?? 'recibido',
            $data['asunto'],
            $data['descripcion'],
            $data['creado_por']
        ]);
    }

    // Actualizar caso
    public function update($id, $data) {
        $stmt = $this->db->prepare('UPDATE contactabilidad_casos SET tipo = ?, estado = ?, asunto = ?, descripcion = ?, fecha_cierre = ?, asignado_a = ?, updated_at = NOW() WHERE id = ?');
        return $stmt->execute([
            $data['tipo'],
            $data['estado'],
            $data['asunto'],
            $data['descripcion'],
            $data['fecha_cierre'] ?? null,
            $data['asignado_a'] ?? null,
            $id
        ]);
    }

    // Eliminar caso (borrado lógico)
    public function delete($id) {
        $stmt = $this->db->prepare('UPDATE contactabilidad_casos SET deleted_at = NOW() WHERE id = ?');
        return $stmt->execute([$id]);
    }
}
