<?php
namespace Core\Models;

use Core\Classes\Database;

class ContactabilidadGestion {
    private $db;

    public function __construct() {
        $this->db = Database::getInstance()->getConnection();
    }

    public function getByCaso($caso_id) {
        $stmt = $this->db->prepare('SELECT * FROM contactabilidad_gestiones WHERE caso_id = ? ORDER BY fecha_gestion DESC');
        $stmt->execute([$caso_id]);
        return $stmt->fetchAll();
    }

    public function create($data) {
        $stmt = $this->db->prepare('INSERT INTO contactabilidad_gestiones (caso_id, usuario_id, accion, fecha_gestion) VALUES (?, ?, ?, NOW())');
        return $stmt->execute([
            $data['caso_id'],
            $data['usuario_id'],
            $data['accion']
        ]);
    }
}
