<?php
namespace Core\Models;

use Core\Classes\Database;

class Empresa {
    private $db;

    public function __construct() {
        $this->db = Database::getInstance()->getConnection();
    }

    // Obtener lista de empresas activas
    public function getAll() {
        $stmt = $this->db->query('SELECT * FROM empresas WHERE deleted_at IS NULL');
        return $stmt->fetchAll();
    }

    // Obtener empresa por ID
    public function getById($id) {
        $stmt = $this->db->prepare('SELECT * FROM empresas WHERE id = ? AND deleted_at IS NULL');
        $stmt->execute([$id]);
        return $stmt->fetch();
    }

    // Crear nueva empresa
    public function create($data) {
        $stmt = $this->db->prepare('INSERT INTO empresas (rut, razon_social, nombre_comercial, direccion, comuna, region, telefono, email, web, estado, fecha_activacion, created_at, updated_at) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW(), NOW())');
        return $stmt->execute([
            $data['rut'],
            $data['razon_social'],
            $data['nombre_comercial'] ?? '',
            $data['direccion'] ?? '',
            $data['comuna'] ?? '',
            $data['region'] ?? '',
            $data['telefono'] ?? '',
            $data['email'] ?? '',
            $data['web'] ?? '',
            $data['estado'] ?? 'activo',
            $data['fecha_activacion'] ?? date('Y-m-d')
        ]);
    }

    // Actualizar empresa
    public function update($id, $data) {
        $stmt = $this->db->prepare('UPDATE empresas SET rut = ?, razon_social = ?, nombre_comercial = ?, direccion = ?, comuna = ?, region = ?, telefono = ?, email = ?, web = ?, estado = ?, fecha_activacion = ?, updated_at = NOW() WHERE id = ?');
        return $stmt->execute([
            $data['rut'],
            $data['razon_social'],
            $data['nombre_comercial'] ?? '',
            $data['direccion'] ?? '',
            $data['comuna'] ?? '',
            $data['region'] ?? '',
            $data['telefono'] ?? '',
            $data['email'] ?? '',
            $data['web'] ?? '',
            $data['estado'] ?? 'activo',
            $data['fecha_activacion'] ?? date('Y-m-d'),
            $id
        ]);
    }

    // Borrado lógico
    public function delete($id) {
        $stmt = $this->db->prepare('UPDATE empresas SET deleted_at = NOW() WHERE id = ?');
        return $stmt->execute([$id]);
    }
}
