<?php
namespace Core\Models;

use Core\Classes\Database;

class Log {
    private $db;

    public function __construct() {
        $this->db = Database::getInstance()->getConnection();
    }

    public function registrar($empresa_id, $usuario_id, $accion, $modulo = null, $datos = null) {
        $stmt = $this->db->prepare('INSERT INTO logs (empresa_id, usuario_id, accion, modulo, ip, user_agent, datos, created_at) VALUES (?, ?, ?, ?, ?, ?, ?, NOW())');
        
        return $stmt->execute([
            $empresa_id,
            $usuario_id,
            $accion,
            $modulo,
            $_SERVER['REMOTE_ADDR'] ?? null,
            $_SERVER['HTTP_USER_AGENT'] ?? null,
            $datos ? json_encode($datos) : null
        ]);
    }

    public function obtenerPorEmpresa($empresa_id) {
        $stmt = $this->db->prepare('SELECT l.*, u.nombres, u.apellidos, u.email FROM logs l LEFT JOIN usuarios u ON l.usuario_id = u.id WHERE l.empresa_id = ? ORDER BY l.created_at DESC LIMIT 1000');
        $stmt->execute([$empresa_id]);
        return $stmt->fetchAll();
    }

    public function obtenerTodos() {
        $stmt = $this->db->query('SELECT l.*, u.nombres, u.apellidos, u.email, e.nombre as empresa_nombre FROM logs l LEFT JOIN usuarios u ON l.usuario_id = u.id LEFT JOIN empresas e ON l.empresa_id = e.id ORDER BY l.created_at DESC LIMIT 1000');
        return $stmt->fetchAll();
    }

    public function obtenerPorUsuario($usuario_id) {
        $stmt = $this->db->prepare('SELECT l.*, u.nombres, u.apellidos FROM logs l LEFT JOIN usuarios u ON l.usuario_id = u.id WHERE l.usuario_id = ? ORDER BY l.created_at DESC LIMIT 100');
        $stmt->execute([$usuario_id]);
        return $stmt->fetchAll();
    }

    public function obtenerPorModulo($empresa_id, $modulo) {
        $stmt = $this->db->prepare('SELECT l.*, u.nombres, u.apellidos FROM logs l LEFT JOIN usuarios u ON l.usuario_id = u.id WHERE l.empresa_id = ? AND l.modulo = ? ORDER BY l.created_at DESC LIMIT 100');
        $stmt->execute([$empresa_id, $modulo]);
        return $stmt->fetchAll();
    }

    public function limpiarAntiguos($dias = 90) {
        $stmt = $this->db->prepare('DELETE FROM logs WHERE created_at < DATE_SUB(NOW(), INTERVAL ? DAY)');
        return $stmt->execute([$dias]);
    }
}
