<?php
namespace Core\Models;

use Core\Classes\Database;

class ProveedorContacto {
    private $db;

    public function __construct() {
        $this->db = Database::getInstance()->getConnection();
    }

    public function getAllByProveedor($proveedor_id) {
        $stmt = $this->db->prepare('SELECT * FROM proveedor_contactos WHERE proveedorid = ? ORDER BY principal DESC, nombre ASC');
        $stmt->execute([$proveedor_id]);
        return $stmt->fetchAll();
    }

    public function getById($id) {
        $stmt = $this->db->prepare('SELECT * FROM proveedor_contactos WHERE id = ?');
        $stmt->execute([$id]);
        return $stmt->fetch();
    }

    public function create($data) {
        $stmt = $this->db->prepare('INSERT INTO proveedor_contactos (proveedorid, nombre, cargo, email, telefono, celular, principal) VALUES (?, ?, ?, ?, ?, ?, ?)');
        return $stmt->execute([
            $data['proveedorid'],
            $data['nombre'],
            $data['cargo'] ?? '',
            $data['email'] ?? '',
            $data['telefono'] ?? '',
            $data['celular'] ?? '',
            $data['principal'] ? 1 : 0
        ]);
    }

    public function update($id, $data) {
        $stmt = $this->db->prepare('UPDATE proveedor_contactos SET nombre = ?, cargo = ?, email = ?, telefono = ?, celular = ?, principal = ? WHERE id = ?');
        return $stmt->execute([
            $data['nombre'],
            $data['cargo'] ?? '',
            $data['email'] ?? '',
            $data['telefono'] ?? '',
            $data['celular'] ?? '',
            $data['principal'] ? 1 : 0,
            $id
        ]);
    }

    public function delete($id) {
        $stmt = $this->db->prepare('DELETE FROM proveedor_contactos WHERE id = ?');
        return $stmt->execute([$id]);
    }
}
