<?php
namespace Core\Models;

use Core\Classes\Database;

class Tesoreria {
    private $db;

    public function __construct() {
        $this->db = Database::getInstance()->getConnection();
    }

    public function getAllByEmpresa($empresa_id) {
        $stmt = $this->db->prepare('SELECT * FROM tesoreria_movimientos WHERE empresa_id = ? ORDER BY fecha_movimiento DESC');
        $stmt->execute([$empresa_id]);
        return $stmt->fetchAll();
    }

    public function getById($id) {
        $stmt = $this->db->prepare('SELECT * FROM tesoreria_movimientos WHERE id = ?');
        $stmt->execute([$id]);
        return $stmt->fetch();
    }

    public function create($data) {
        $stmt = $this->db->prepare('INSERT INTO tesoreria_movimientos (empresa_id, tipo, monto, cuenta, descripcion, fecha_movimiento, creado_por) VALUES (?, ?, ?, ?, ?, ?, ?)');
        return $stmt->execute([
            $data['empresa_id'],
            $data['tipo'],
            $data['monto'],
            $data['cuenta'],
            $data['descripcion'],
            $data['fecha_movimiento'],
            $data['creado_por']
        ]);
    }

    public function update($id, $data) {
        $stmt = $this->db->prepare('UPDATE tesoreria_movimientos SET tipo = ?, monto = ?, cuenta = ?, descripcion = ?, fecha_movimiento = ?, actualizado_por = ?, fecha_actualizacion = NOW() WHERE id = ?');
        return $stmt->execute([
            $data['tipo'],
            $data['monto'],
            $data['cuenta'],
            $data['descripcion'],
            $data['fecha_movimiento'],
            $data['actualizado_por'],
            $id
        ]);
    }

    public function delete($id) {
        $stmt = $this->db->prepare('DELETE FROM tesoreria_movimientos WHERE id = ?');
        return $stmt->execute([$id]);
    }
}
