<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Editar Caso</title>
    <link rel="stylesheet" href="/public/css/style.css" />
</head>
<body>
    <h1>Editar Caso #<?= htmlspecialchars($caso['id']) ?></h1>

    <?php if (isset($error)): ?>
        <p class="error"><?= htmlspecialchars($error) ?></p>
    <?php endif; ?>

    <form method="POST" action="/caso/update/<?= $caso['id'] ?>">
        <label for="tipo">Tipo</label>
        <input type="text" id="tipo" name="tipo" value="<?= htmlspecialchars($caso['tipo']) ?>" required />

        <label for="estado">Estado</label>
        <input type="text" id="estado" name="estado" value="<?= htmlspecialchars($caso['estado']) ?>" required />

        <label for="asunto">Asunto</label>
        <input type="text" id="asunto" name="asunto" value="<?= htmlspecialchars($caso['asunto']) ?>" required />

        <label for="descripcion">Descripción</label>
        <textarea id="descripcion" name="descripcion" required><?= htmlspecialchars($caso['descripcion']) ?></textarea>

        <label for="asignado_a">Asignado a</label>
        <input type="number" id="asignado_a" name="asignado_a" value="<?= htmlspecialchars($caso['asignado_a']) ?>" />

        <button type="submit">Actualizar Caso</button>
    </form>

    <a href="/caso">Volver al listado</a>
</body>
</html>
