<?php
$pageTitle = 'Gestión de Clientes';
require_once __DIR__ . '/../layouts/header.php';

use Core\Classes\Permission;
Permission::requirePermission('ver_clientes');
?>

<div class="container">
    <div class="page-header">
        <div>
            <h1><i class="fas fa-users"></i> Gestión de Clientes</h1>
            <p>Administra los clientes del SSR</p>
        </div>
        <div class="page-header-actions">
            <?php if (Permission::can('gestionar_clientes')): ?>
                <a href="/cliente/create" class="btn btn-primary">
                    <i class="fas fa-user-plus"></i> Nuevo Cliente
                </a>
            <?php endif; ?>
        </div>
    </div>
    
    <div class="content-card">
        <table>
            <thead>
                <tr>
                    <th>ID</th>
                    <th>RUT</th>
                    <th>Nombre</th>
                    <th>Email</th>
                    <th>Teléfono</th>
                    <th>Estado</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($clientes)): ?>
                    <tr>
                        <td colspan="7">
                            <div class="empty-state">
                                <i class="fas fa-users"></i>
                                <h3>No hay clientes registrados</h3>
                                <?php if (Permission::can('gestionar_clientes')): ?>
                                    <a href="/cliente/create" class="btn btn-primary">
                                        <i class="fas fa-user-plus"></i> Crear Cliente
                                    </a>
                                <?php endif; ?>
                            </div>
                        </td>
                    </tr>
                <?php else: ?>
                    <?php foreach ($clientes as $cliente): ?>
                        <tr>
                            <td><?= htmlspecialchars($cliente['id']) ?></td>
                            <td><?= htmlspecialchars($cliente['rut']) ?></td>
                            <td><strong><?= htmlspecialchars($cliente['nombres'] . ' ' . $cliente['apellidos']) ?></strong></td>
                            <td><?= htmlspecialchars($cliente['email'] ?? '-') ?></td>
                            <td><?= htmlspecialchars($cliente['telefono'] ?? '-') ?></td>
                            <td>
                                <?php if ($cliente['estado'] === 'activo'): ?>
                                    <span class="badge badge-success">Activo</span>
                                <?php else: ?>
                                    <span class="badge badge-danger">Inactivo</span>
                                <?php endif; ?>
                            </td>
                            <td class="actions">
                                <a href="/cliente/edit/<?= $cliente['id'] ?>" class="btn btn-sm btn-warning">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <?php if (Permission::can('gestionar_clientes')): ?>
                                    <a href="/cliente/delete/<?= $cliente['id'] ?>" 
                                       onclick="return confirm('¿Eliminar este cliente?')" 
                                       class="btn btn-sm btn-danger">
                                        <i class="fas fa-trash"></i>
                                    </a>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once __DIR__ . '/../layouts/footer.php'; ?>
