<?php
$pageTitle = 'Dashboard';
require_once __DIR__ . '/../layouts/header.php';

use Core\Classes\Permission;

// Corregido: Definir $isSuperadmin SIEMPRE antes de usarlo
$isSuperadmin = (isset($_SESSION['user_role']) && $_SESSION['user_role'] === 'superadmin');

// Dummy para pruebas local (si no se recibe desde el controller):
$stats = $stats ?? [
    'total_clientes' => 247,
    'casos_activos' => 18,
    'casos_resueltos' => 342,
    'ingresos_mes' => 2500000
];

$actividad_reciente = $actividad_reciente ?? [];
?>

<div class="container">
    <div class="welcome-banner">
        <h1>¡Bienvenido, <?= htmlspecialchars(explode(' ', $_SESSION['user_name'] ?? 'Usuario')[0]) ?>!</h1>
        <p>Sistema de Gestión para Servicios Sanitarios Rurales - Empresa ID: <?= $_SESSION['empresa_id'] ?? 'N/A' ?></p>
    </div>

    <div class="metrics-grid">
        <div class="metric-card">
            <div class="metric-icon"><i class="fas fa-users"></i></div>
            <div class="metric-content">
                <h3>TOTAL CLIENTES</h3>
                <p class="metric-value"><?= number_format($stats['total_clientes'], 0, ',', '.') ?></p>
                <span class="metric-trend positive">+12% este mes</span>
            </div>
        </div>
        <div class="metric-card">
            <div class="metric-icon"><i class="fas fa-folder-open"></i></div>
            <div class="metric-content">
                <h3>CASOS ACTIVOS</h3>
                <p class="metric-value"><?= number_format($stats['casos_activos'], 0, ',', '.') ?></p>
                <span class="metric-trend negative">-5% esta semana</span>
            </div>
        </div>
        <div class="metric-card">
            <div class="metric-icon"><i class="fas fa-check-circle"></i></div>
            <div class="metric-content">
                <h3>CASOS RESUELTOS</h3>
                <p class="metric-value"><?= number_format($stats['casos_resueltos'], 0, ',', '.') ?></p>
                <span class="metric-trend positive">+8% este mes</span>
            </div>
        </div>
        <div class="metric-card">
            <div class="metric-icon"><i class="fas fa-dollar-sign"></i></div>
            <div class="metric-content">
                <h3>INGRESOS MES</h3>
                <p class="metric-value">$<?= number_format($stats['ingresos_mes'], 0, ',', '.') ?></p>
                <span class="metric-trend positive">+13% vs mes anterior</span>
            </div>
        </div>
    </div>

    <div class="content-card">
        <h2><i class="fas fa-bolt"></i> Acciones Rápidas</h2>
        <div class="quick-actions">
            <?php if ($isSuperadmin): ?>
                <a href="/empresa/create" class="action-btn">
                    <i class="fas fa-building"></i>
                    <span>Nueva Empresa</span>
                </a>
                <a href="/usuario/create" class="action-btn">
                    <i class="fas fa-user-shield"></i>
                    <span>Nuevo Usuario</span>
                </a>
                <a href="/backup/create" class="action-btn">
                    <i class="fas fa-download"></i>
                    <span>Crear Respaldo</span>
                </a>
                <a href="/admin/empresa_modulo.php" class="action-btn">
                <i class="fas fa-cogs"></i>
                <span>Activar/Desactivar Módulos</span>
                </a>

            <?php else: ?>
                <?php if (Permission::can('crear_caso')): ?>
                    <a href="/caso/create" class="action-btn">
                        <i class="fas fa-plus-circle"></i>
                        <span>Nuevo Caso</span>
                    </a>
                <?php endif; ?>
                <?php if (Permission::can('gestionar_clientes')): ?>
                    <a href="/cliente/create" class="action-btn">
                        <i class="fas fa-user-plus"></i>
                        <span>Nuevo Cliente</span>
                    </a>
                <?php endif; ?>
                <!-- Puedes agregar aquí otros botones según los permisos del rol -->
            <?php endif; ?>
        </div>
    </div>

    <div class="content-card">
        <h2><i class="fas fa-clock"></i> Actividad Reciente</h2>
        <div class="activity-list">
            <?php if (!empty($actividad_reciente)): ?>
                <?php foreach ($actividad_reciente as $actividad): ?>
                    <div class="activity-item">
                        <div class="activity-icon">
                            <i class="fas fa-info-circle"></i>
                        </div>
                        <div class="activity-content">
                            <p class="activity-time">Hace <?= htmlspecialchars($actividad['tiempo']) ?> minutos</p>
                            <p><?= htmlspecialchars($actividad['descripcion']) ?></p>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <div class="empty-state">
                    <i class="fas fa-history"></i>
                    <p>No hay actividad reciente</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<style>
.welcome-banner {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 40px;
    border-radius: 12px;
    margin-bottom: 30px;
    box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
}
.welcome-banner h1 { font-size: 2rem; margin-bottom: 10px; font-weight: 600; }
.welcome-banner p { font-size: 1.1rem; opacity: 0.95; }

.metrics-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 20px;
    margin-bottom: 30px;
}
.metric-card {
    background: white;
    padding: 25px;
    border-radius: 12px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.08);
    display: flex;
    gap: 20px;
    align-items: center;
    transition: transform 0.3s, box-shadow 0.3s;
}
.metric-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 20px rgba(0,0,0,0.12);
}
.metric-icon { font-size: 2.5rem; color: #667eea; opacity: 0.2; }
.metric-content h3 {
    font-size: 0.85rem;
    color: #6c757d;
    margin-bottom: 10px;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}
.metric-value { font-size: 2.5rem; font-weight: 700; color: #2c3e50; margin: 10px 0; line-height: 1; }
.metric-trend { font-size: 0.85rem; padding: 4px 8px; border-radius: 4px; display: inline-block; }
.metric-trend.positive { background: #d4edda; color: #155724;}
.metric-trend.negative { background: #f8d7da; color: #721c24;}
.metric-trend i { margin-right: 4px; }

.quick-actions {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(180px, 1fr));
    gap: 15px;
    margin-top: 20px;
}
.action-btn {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 10px;
    padding: 25px 15px;
    background: #f8f9fa;
    border-radius: 12px;
    text-decoration: none;
    color: #495057;
    transition: all 0.3s;
    text-align: center;
}
.action-btn:hover {
    background: #667eea;
    color: white;
    transform: translateY(-3px);
    box-shadow: 0 8px 16px rgba(102,126,234,0.3);
}
.action-btn i { font-size: 2rem; }
.action-btn span { font-weight: 500; font-size: 0.9rem; }

.activity-list { margin-top: 20px; }
.activity-item {
    display: flex;
    gap: 15px;
    padding: 15px;
    border-bottom: 1px solid #e9ecef;
    transition: background 0.3s;
}
.activity-item:last-child { border-bottom: none; }
.activity-item:hover { background: #f8f9fa; }
.activity-icon { font-size: 1.5rem; color: #667eea; flex-shrink: 0; }
.activity-time { font-size: 0.85rem; color: #6c757d; margin-bottom: 5px; }
.activity-content p:last-child { color: #2c3e50; margin: 0; }
.empty-state {
    text-align: center;
    padding: 40px 20px;
    color: #6c757d;
}
.empty-state i { font-size: 3rem; margin-bottom: 15px; opacity: 0.3; }
.empty-state p { margin: 0; font-size: 1.1rem; }

@media (max-width: 768px) {
    .metrics-grid { grid-template-columns: 1fr; }
    .quick-actions { grid-template-columns: repeat(2,1fr); }
    .welcome-banner h1 { font-size: 1.5rem; }
    .metric-value { font-size: 2rem; }
}
</style>

<?php require_once __DIR__ . '/../layouts/footer.php'; ?>
