<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Editar Empresa</title>
    <style>
        body { 
            font-family: Arial, sans-serif; 
            padding: 20px; 
            max-width: 800px; 
            margin: 0 auto;
        }
        h1 { color: #333; }
        form { 
            background: #f9f9f9; 
            padding: 20px; 
            border-radius: 8px; 
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        .form-group { 
            margin-bottom: 15px; 
        }
        label { 
            display: block; 
            margin-bottom: 5px; 
            font-weight: bold; 
            color: #555;
        }
        input, textarea { 
            width: 100%; 
            padding: 10px; 
            border: 1px solid #ddd; 
            border-radius: 4px; 
            box-sizing: border-box;
            font-size: 14px;
        }
        textarea {
            min-height: 80px;
            resize: vertical;
        }
        .btn { 
            padding: 12px 24px; 
            background: #667eea; 
            color: white; 
            border: none; 
            border-radius: 4px; 
            cursor: pointer;
            font-size: 16px;
            margin-right: 10px;
        }
        .btn:hover { 
            background: #5568d3; 
        }
        .btn-secondary {
            background: #6c757d;
        }
        .btn-secondary:hover {
            background: #5a6268;
        }
        .error {
            color: #e74c3c;
            background: #fadbd8;
            padding: 10px;
            border-radius: 4px;
            margin-bottom: 15px;
        }
    </style>
</head>
<body>
    <h1>Editar Empresa</h1>
    
    <?php if (isset($error)): ?>
        <div class="error"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>
    
    <form method="POST" action="/empresa/update/<?= htmlspecialchars($empresa['id']) ?>">
        <div class="form-group">
            <label for="nombre">Nombre de la Empresa *</label>
            <input type="text" id="nombre" name="nombre" value="<?= htmlspecialchars($empresa['nombre'] ?? '') ?>" required>
        </div>
        
        <div class="form-group">
            <label for="rut">RUT *</label>
            <input type="text" id="rut" name="rut" value="<?= htmlspecialchars($empresa['rut'] ?? '') ?>" required placeholder="76.123.456-7">
        </div>
        
        <div class="form-group">
            <label for="direccion">Dirección</label>
            <input type="text" id="direccion" name="direccion" value="<?= htmlspecialchars($empresa['direccion'] ?? '') ?>" placeholder="Av. Principal 123">
        </div>
        
        <div class="form-group">
            <label for="telefono">Teléfono</label>
            <input type="text" id="telefono" name="telefono" value="<?= htmlspecialchars($empresa['telefono'] ?? '') ?>" placeholder="+56912345678">
        </div>
        
        <div class="form-group">
            <label for="email">Email</label>
            <input type="email" id="email" name="email" value="<?= htmlspecialchars($empresa['email'] ?? '') ?>" placeholder="contacto@empresa.cl">
        </div>
        
        <div class="form-group">
            <button type="submit" class="btn">Guardar Cambios</button>
            <a href="/empresa" class="btn btn-secondary" style="display: inline-block; text-decoration: none; text-align: center;">Cancelar</a>
        </div>
    </form>
</body>
</html>
