<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Editar Seguimiento</title>
    <link rel="stylesheet" href="/public/css/style.css" />
</head>
<body>
    <h1>Editar Seguimiento #<?= htmlspecialchars($seguimiento['id']) ?></h1>

    <?php if (isset($error)): ?>
        <p class="error"><?= htmlspecialchars($error) ?></p>
    <?php endif; ?>

    <form method="POST" action="/seguimiento/update/<?= $seguimiento['id'] ?>">
        <label for="entidad">Entidad</label>
        <input type="text" id="entidad" name="entidad" value="<?= htmlspecialchars($seguimiento['entidad']) ?>" required />

        <label for="entidad_id">ID de Entidad</label>
        <input type="number" id="entidad_id" name="entidad_id" value="<?= htmlspecialchars($seguimiento['entidad_id']) ?>" required />

        <label for="descripcion">Descripción</label>
        <textarea id="descripcion" name="descripcion" required><?= htmlspecialchars($seguimiento['descripcion']) ?></textarea>

        <label for="estado">Estado</label>
        <select id="estado" name="estado">
            <option value="pendiente" <?= $seguimiento['estado'] === 'pendiente' ? 'selected' : '' ?>>Pendiente</option>
            <option value="completado" <?= $seguimiento['estado'] === 'completado' ? 'selected' : '' ?>>Completado</option>
            <option value="cancelado" <?= $seguimiento['estado'] === 'cancelado' ? 'selected' : '' ?>>Cancelado</option>
        </select>

        <label for="fecha_seguimiento">Fecha Seguimiento</label>
        <input type="date" id="fecha_seguimiento" name="fecha_seguimiento" value="<?= htmlspecialchars(substr($seguimiento['fecha_seguimiento'], 0, 10)) ?>" required />

        <button type="submit">Actualizar Seguimiento</button>
    </form>

    <a href="/seguimiento">Volver al listado</a>
</body>
</html>
