<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Seguimientos</title>
    <link rel="stylesheet" href="/public/css/style.css" />
</head>
<body>
    <h1>Seguimientos</h1>
    <a href="/seguimiento/create">Nuevo Seguimiento</a>
    <table border="1" cellpadding="5" cellspacing="0">
        <thead>
            <tr>
                <th>ID</th>
                <th>Entidad</th>
                <th>Entidad ID</th>
                <th>Descripción</th>
                <th>Estado</th>
                <th>Fecha Seguimiento</th>
                <th>Acciones</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($seguimientos as $seg): ?>
            <tr>
                <td><?= htmlspecialchars($seg['id']) ?></td>
                <td><?= htmlspecialchars($seg['entidad']) ?></td>
                <td><?= htmlspecialchars($seg['entidad_id']) ?></td>
                <td><?= htmlspecialchars($seg['descripcion']) ?></td>
                <td><?= htmlspecialchars($seg['estado']) ?></td>
                <td><?= htmlspecialchars($seg['fecha_seguimiento']) ?></td>
                <td>
                    <a href="/seguimiento/edit/<?= $seg['id'] ?>">Editar</a> |
                    <a href="/seguimiento/delete/<?= $seg['id'] ?>" onclick="return confirm('¿Confirmar eliminación?')">Eliminar</a>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</body>
</html>
