<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Editar Movimiento</title>
    <link rel="stylesheet" href="/public/css/style.css" />
</head>
<body>
    <h1>Editar Movimiento #<?= htmlspecialchars($movimiento['id']) ?></h1>

    <?php if (isset($error)): ?>
        <p class="error"><?= htmlspecialchars($error) ?></p>
    <?php endif; ?>

    <form method="POST" action="/tesoreria/update/<?= $movimiento['id'] ?>">
        <label for="tipo">Tipo</label>
        <input type="text" id="tipo" name="tipo" value="<?= htmlspecialchars($movimiento['tipo']) ?>" required />

        <label for="monto">Monto</label>
        <input type="number" step="0.01" id="monto" name="monto" value="<?= htmlspecialchars($movimiento['monto']) ?>" required />

        <label for="cuenta">Cuenta</label>
        <input type="text" id="cuenta" name="cuenta" value="<?= htmlspecialchars($movimiento['cuenta']) ?>" />

        <label for="fecha_movimiento">Fecha Movimiento</label>
        <input type="date" id="fecha_movimiento" name="fecha_movimiento" value="<?= htmlspecialchars(substr($movimiento['fecha_movimiento'], 0, 10)) ?>" required />

        <label for="descripcion">Descripción</label>
        <textarea id="descripcion" name="descripcion"><?= htmlspecialchars($movimiento['descripcion']) ?></textarea>

        <button type="submit">Actualizar Movimiento</button>
    </form>

    <a href="/tesoreria">Volver al listado</a>
</body>
</html>
