<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Movimientos de Tesorería</title>
    <link rel="stylesheet" href="/public/css/style.css" />
</head>
<body>
    <h1>Movimientos</h1>
    <a href="/tesoreria/create">Nuevo Movimiento</a>
    <table border="1" cellpadding="5" cellspacing="0">
        <thead>
            <tr>
                <th>ID</th>
                <th>Tipo</th>
                <th>Monto</th>
                <th>Cuenta</th>
                <th>Fecha Movimiento</th>
                <th>Descripción</th>
                <th>Acciones</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($movimientos as $mov): ?>
            <tr>
                <td><?= htmlspecialchars($mov['id']) ?></td>
                <td><?= htmlspecialchars($mov['tipo']) ?></td>
                <td><?= htmlspecialchars($mov['monto']) ?></td>
                <td><?= htmlspecialchars($mov['cuenta']) ?></td>
                <td><?= htmlspecialchars($mov['fecha_movimiento']) ?></td>
                <td><?= htmlspecialchars($mov['descripcion']) ?></td>
                <td>
                    <a href="/tesoreria/edit/<?= $mov['id'] ?>">Editar</a> |
                    <a href="/tesoreria/delete/<?= $mov['id'] ?>" onclick="return confirm('¿Confirmar eliminación?')">Eliminar</a>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</body>
</html>
