<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Nuevo Usuario</title>
    <link rel="stylesheet" href="/public/css/style.css" />
</head>
<body>
    <h1>Nuevo Usuario</h1>

    <?php if (isset($error)): ?>
        <p class="error"><?= htmlspecialchars($error) ?></p>
    <?php endif; ?>

    <form method="POST" action="/usuario/store">
        <label for="rut">RUT</label>
        <input type="text" id="rut" name="rut" required />

        <label for="nombres">Nombres</label>
        <input type="text" id="nombres" name="nombres" required />

        <label for="apellidos">Apellidos</label>
        <input type="text" id="apellidos" name="apellidos" required />

        <label for="email">Email</label>
        <input type="email" id="email" name="email" required />

        <label for="telefono">Teléfono</label>
        <input type="text" id="telefono" name="telefono" />

        <label for="password">Contraseña</label>
        <input type="password" id="password" name="password" required />

        <label for="rol">Rol</label>
        <select id="rol" name="rol">
            <option value="cliente" selected>Cliente</option>
            <option value="administrador">Administrador</option>
            <option value="usuario">Usuario</option>
        </select>

        <button type="submit">Guardar Usuario</button>
    </form>

    <a href="/usuario">Volver al listado</a>
</body>
</html>
